/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret;

import icbm.sentry.interfaces.IEnergyTurret;
import icbm.sentry.interfaces.IEnergyWeapon;
import icbm.sentry.interfaces.IKillCount;
import icbm.sentry.interfaces.ISentryTrait;
import icbm.sentry.interfaces.ITurretProvider;
import icbm.sentry.interfaces.IUpgrade;
import icbm.sentry.interfaces.IWeaponProvider;
import icbm.sentry.interfaces.IWeaponSystem;
import icbm.sentry.turret.TurretRegistry;
import icbm.sentry.turret.ai.EulerServo;
import icbm.sentry.turret.ai.TurretAI;
import icbm.sentry.turret.traits.SentryTrait;
import icbm.sentry.turret.traits.SentryTraitDouble;
import icbm.sentry.turret.traits.SentryTraitInteger;
import icbm.sentry.turret.traits.SentryTraitLong;
import icbm.sentry.weapon.WeaponSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.nbt.SaveManager;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public abstract class Turret
implements IEnergyTurret,
IWeaponProvider,
IKillCount {
    private final ITurretProvider host;
    private final HashMap<String, Double> upgrade_count = new HashMap();
    private final HashMap<String, ISentryTrait> traits = new HashMap();
    private final HashMap<String, Integer> kill_count = new HashMap();
    protected WeaponSystem weaponSystem;
    protected Vector3 barrelOffset = new Vector3();
    protected Vector3 centerOffset = new Vector3();
    private int cooldown = 0;
    protected long ticks = 0L;
    protected float barrelLength = 1.0f;
    private EulerServo servo;
    public EnergyStorageHandler battery;
    private TurretAI ai;

    public Turret(ITurretProvider host) {
        this.host = host;
        this.ai = new TurretAI(this);
        this.battery = new EnergyStorageHandler(){

            public long getEnergyCapacity() {
                return SentryTrait.asLong(Turret.this.getTrait("body.energy.storage"), this.capacity);
            }

            public long getMaxReceive() {
                return this.getEnergyCapacity();
            }

            public long getMaxExtract() {
                return this.getEnergyCapacity();
            }
        };
        this.newTrait(new SentryTraitLong("body.energy.storage", "energy.storage", 100000L));
        this.newTrait(new SentryTraitLong("body.energy.running", "energy.efficiency", 10L));
        this.newTrait(new SentryTraitDouble("body.health.max", 50.0));
        this.newTrait(new SentryTraitDouble("ai.search.range", "target.range", 20.0));
        this.newTrait(new SentryTraitDouble("body.rotation", 5.0));
        this.newTrait(new SentryTraitDouble("body.rotation.target", 7.0));
        this.newTrait(new SentryTraitInteger("weapon.ammo.reload", 20));
    }

    public void init() {
        this.onInventoryChanged();
        this.onSettingsChanged();
    }

    @Override
    public void update() {
        this.tick();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public void tick() {
        if (this.ticks == 0L) {
            this.init();
        }
        ++this.ticks;
        if (this.ticks >= 0x7FFFFFFFFFFFFFF5L) {
            this.ticks = 1L;
        }
    }

    public void newTrait(ISentryTrait<?> value) {
        if (this.ticks == 0L) {
            this.traits.put(value.getName(), value);
        }
    }

    public void setTrait(String value, Object data) {
        ISentryTrait trait;
        if (this.ticks == 0L && data != null && (trait = this.getTrait(value)) != null) {
            try {
                trait.setDefaultValue(data);
                trait.setValue(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canFire() {
        boolean cooldown_flag = this.cooldown <= 0;
        boolean fire_flag = this.getWeaponSystem().canFire();
        if (this.getWeaponSystem() instanceof IEnergyWeapon && this.battery.extractEnergy(((IEnergyWeapon)this.getWeaponSystem()).getEnergyPerShot(), false) < ((IEnergyWeapon)this.getWeaponSystem()).getEnergyPerShot()) {
            return false;
        }
        return cooldown_flag && fire_flag;
    }

    @Override
    public boolean fire(IVector3 target) {
        if (this.getHost().world().field_72995_K) {
            this.getWeaponSystem().fireClient(target);
            return true;
        }
        if (this.canFire()) {
            if (target != null) {
                this.getHost().sendFireEventToClient(target);
            }
            this.getWeaponSystem().fire(target);
            if (this.getWeaponSystem() instanceof IEnergyWeapon) {
                this.battery.extractEnergy(((IEnergyWeapon)this.getWeaponSystem()).getEnergyPerShot(), true);
            }
            this.cooldown = SentryTrait.asInt(this.getTrait("weapon.ammo.reload"), 13);
            return true;
        }
        return false;
    }

    @Override
    public boolean fire(Entity target) {
        if (this.getHost().world().field_72995_K) {
            this.getWeaponSystem().fireClient((IVector3)Vector3.fromCenter((Entity)target));
            return true;
        }
        if (this.canFire()) {
            if (target != null) {
                this.getHost().sendFireEventToClient((IVector3)Vector3.fromCenter((Entity)target));
            }
            this.getWeaponSystem().fire(target);
            if (this.getWeaponSystem() instanceof IEnergyWeapon) {
                this.battery.extractEnergy(((IEnergyWeapon)this.getWeaponSystem()).getEnergyPerShot(), true);
            }
            this.cooldown = SentryTrait.asInt(this.getTrait("weapon.ammo.reload"), 10);
            return true;
        }
        return false;
    }

    @Override
    public Vector3 getWeaponOffset() {
        return new Vector3((IVector3)this.getServo()).scale((double)this.barrelLength).translate((IVector3)this.barrelOffset);
    }

    public Vector3 getCenterOffset() {
        return this.centerOffset.clone();
    }

    public void setEnergy(ForgeDirection dir, long energy) {
        this.battery.setEnergy(energy);
    }

    public long getEnergy(ForgeDirection dir) {
        return this.battery.getEnergy();
    }

    public long getEnergyCapacity(ForgeDirection dir) {
        return this.battery.getEnergyCapacity();
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74778_a("sentryID", SaveManager.getID(this.getClass()));
        if (this.battery != null) {
            this.battery.writeToNBT(nbt);
        }
        nbt.func_74780_a("yaw", this.getServo().yaw);
        nbt.func_74780_a("pitch", this.getServo().pitch);
        NBTTagList killCounts = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.kill_count.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            NBTTagCompound accessData = new NBTTagCompound();
            accessData.func_74778_a("name", entry.getKey());
            accessData.func_74768_a("count", entry.getValue().intValue());
            killCounts.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("killCount", (NBTBase)killCounts);
    }

    public void load(NBTTagCompound nbt) {
        if (this.battery != null) {
            this.battery.readFromNBT(nbt);
        }
        this.getServo().yaw = nbt.func_74769_h("yaw");
        this.getServo().pitch = nbt.func_74769_h("pitch");
        this.getServo().hasChanged = true;
        NBTTagList nodeList = nbt.func_74761_m("killCount");
        this.kill_count.clear();
        for (int i = 0; i < nodeList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)nodeList.func_74743_b(i);
            this.kill_count.put(tag.func_74779_i("name"), tag.func_74762_e("count"));
        }
    }

    @Override
    public ITurretProvider getHost() {
        return this.host;
    }

    public World world() {
        return this.getHost().world();
    }

    public double x() {
        return this.getHost().x();
    }

    public double y() {
        return this.getHost().y();
    }

    public double z() {
        return this.getHost().z();
    }

    public double yaw() {
        return this.getServo().yaw;
    }

    public double pitch() {
        return this.getServo().pitch;
    }

    public double roll() {
        return this.getServo().roll;
    }

    public VectorWorld getPosition() {
        return new VectorWorld(this.world(), this.x(), this.y(), this.z());
    }

    public VectorWorld fromCenter() {
        return (VectorWorld)this.getPosition().translate((IVector3)this.getCenterOffset());
    }

    public EulerServo getServo() {
        if (this.servo == null) {
            this.servo = new EulerServo(5.0);
        }
        return this.servo;
    }

    public String toString() {
        String id = TurretRegistry.getID(this);
        return "[Turret] ID: " + (id != null ? id : "unknown") + "   " + super.toString();
    }

    public TurretAI getAi() {
        return this.ai;
    }

    @Override
    public IWeaponSystem getWeaponSystem() {
        return this.weaponSystem;
    }

    @Override
    public void onSettingsChanged() {
    }

    @Override
    public void onInventoryChanged() {
        IInventory inv = this.getHost().getInventory();
        this.upgrade_count.clear();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            if (inv.func_70301_a(slot) == null || !(inv.func_70301_a(slot).func_77973_b() instanceof IUpgrade) || !((IUpgrade)inv.func_70301_a(slot).func_77973_b()).canApplyTo(inv.func_70301_a(slot), this)) continue;
            ArrayList<String> id_list = new ArrayList<String>();
            ((IUpgrade)inv.func_70301_a(slot).func_77973_b()).getTypes(id_list, inv.func_70301_a(slot));
            for (String id : id_list) {
                if (!this.upgrade_count.containsKey(id)) {
                    this.upgrade_count.put(id, 0.0);
                }
                this.upgrade_count.put(id, this.upgrade_count.get(id) + ((IUpgrade)inv.func_70301_a(slot).func_77973_b()).getUpgradeEfficiance(inv.func_70301_a(slot), id));
            }
        }
        for (Map.Entry<String, ISentryTrait> entry : this.traits().entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().updateTrait(this);
        }
    }

    @Override
    public HashMap<String, Double> upgrades() {
        return this.upgrade_count;
    }

    @Override
    public double getUpgradeEffect(String upgrade) {
        if (this.upgrades().containsKey(upgrade)) {
            return this.upgrades().get(upgrade);
        }
        return 0.0;
    }

    @Override
    public HashMap<String, ISentryTrait> traits() {
        return this.traits;
    }

    @Override
    public ISentryTrait getTrait(String trait) {
        if (this.traits().containsKey(trait)) {
            return this.traits().get(trait);
        }
        return new SentryTraitDouble(trait, 0.0);
    }

    @Override
    public int getKillCount() {
        return this.getKillCount("Total");
    }

    @Override
    public int getKillCount(String type) {
        return this.kill_count.containsKey(type) ? this.kill_count.get(type) : 0;
    }

    @Override
    public void onKillOfEntity(Entity entity) {
        if (entity != null) {
            if (entity instanceof IMob) {
                this.increaseKill("Mobs");
            } else if (entity instanceof INpc) {
                this.increaseKill("NPCs");
            } else if (entity instanceof IAnimals) {
                this.increaseKill("Animals");
            } else if (entity instanceof EntityPlayer) {
                this.increaseKill("Players");
                this.increaseKill(((EntityPlayer)entity).field_71092_bJ);
            } else {
                this.increaseKill(EntityList.func_75621_b((Entity)entity));
            }
            this.increaseKill("Total");
        }
    }

    private void increaseKill(String type) {
        if (type != null && !type.isEmpty()) {
            this.kill_count.put(type, 1 + (this.kill_count.containsKey(type) ? this.kill_count.get(type) : 0));
        }
    }

    @Override
    public long getRunningCost() {
        return SentryTrait.asLong(this.getTrait("body.energy.running"), 0L);
    }
}

