/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret;

import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.ICBMCore;
import icbm.sentry.ICBMSentry;
import icbm.sentry.render.TurretRenderer;
import icbm.sentry.turret.Turret;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.utility.ReflectionUtility;
import resonant.lib.utility.nbt.SaveManager;

public class TurretRegistry {
    private static HashBiMap<String, Class<? extends Turret>> sentryMap = HashBiMap.create();
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Class<? extends Turret>, TurretRenderer> sentryRenderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSentry(String key, Class<? extends Turret> sentry) {
        HashBiMap<String, Class<? extends Turret>> hashBiMap = sentryMap;
        synchronized (hashBiMap) {
            if (!sentryMap.containsKey((Object)key)) {
                sentryMap.put((Object)key, sentry);
                SaveManager.registerClass((String)("Sentry-" + key), sentry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static void registerSentryRenderer(Class<? extends Turret> sentry, TurretRenderer render) {
        if (sentryRenderMap == null) {
            sentryRenderMap = new HashMap();
        }
        HashMap<Class<? extends Turret>, TurretRenderer> hashMap = sentryRenderMap;
        synchronized (hashMap) {
            if (!sentryRenderMap.containsKey(sentry)) {
                System.out.println("[SentryRegistry]Registering Sentry Renderer. Sentry: " + sentry.getName() + "  Renderer: " + render.getClass().getName());
                sentryRenderMap.put(sentry, render);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TurretRenderer getRenderFor(Turret sentry) {
        Class<?> clazz;
        if (sentry != null && sentryRenderMap.containsKey(clazz = sentry.getClass())) {
            return sentryRenderMap.get(sentry.getClass());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static TurretRenderer getRenderFor(Class<? extends Turret> sentry) {
        return sentryRenderMap.get(sentry);
    }

    public static HashBiMap<String, Class<? extends Turret>> getSentryMap() {
        return sentryMap;
    }

    public static Class<? extends Turret> getSentry(String id) {
        return (Class)sentryMap.get((Object)id);
    }

    public static String getID(Turret sentry) {
        return (String)sentryMap.inverse().get(sentry.getClass());
    }

    public static String getID(Class<? extends Turret> sentry) {
        return (String)sentryMap.inverse().get(sentry);
    }

    public static Turret constructSentry(NBTTagCompound compoundTag, Object ... args) {
        Object object = SaveManager.createAndLoad((NBTTagCompound)compoundTag, (Object[])args);
        if (object instanceof Turret) {
            return (Turret)object;
        }
        return null;
    }

    public static Turret constructSentry(String sentryID, Object ... args) {
        Object candidate = null;
        Turret sentryModule = null;
        try {
            Class clazz = SaveManager.getClass((String)sentryID);
            if (clazz != null) {
                Constructor con = ReflectionUtility.getConstructorWithArgs((Class)clazz, (Object[])args);
                if (con != null) {
                    candidate = con.newInstance(args);
                }
                if (candidate instanceof Turret) {
                    sentryModule = candidate;
                } else {
                    ICBMCore.LOGGER.severe("Construction of turret '" + sentryID + "' failed, an unexpected object '" + con + "' was created");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sentryModule;
    }

    public static ItemStack getItemStack(Class<? extends Turret> sentry) {
        ItemStack stack = new ItemStack(ICBMSentry.blockTurret);
        NBTTagCompound itemNbt = new NBTTagCompound();
        NBTTagCompound sentry_nbt = new NBTTagCompound();
        itemNbt.func_74778_a("unlocalizedName", TurretRegistry.getID(sentry));
        sentry_nbt.func_74778_a("sentryID", SaveManager.getID(sentry));
        itemNbt.func_74766_a("sentryTile", sentry_nbt);
        stack.func_77982_d(itemNbt);
        return stack;
    }
}

