/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret;

import icbm.sentry.turret.Turret;
import icbm.sentry.turret.TurretRegistry;
import icbm.sentry.turret.auto.TurretAntiAir;
import icbm.sentry.turret.auto.TurretAutoBow;
import icbm.sentry.turret.auto.TurretGun;
import icbm.sentry.turret.auto.TurretLaser;
import icbm.sentry.turret.mounted.MountedRailgun;
import resonant.lib.utility.LanguageUtility;

public enum TurretType {
    GUN_TURRET(TurretGun.class),
    LASER_TURRET(TurretLaser.class),
    ANTI_AIRCRAFT_TURRET(TurretAntiAir.class),
    RAILGUN(MountedRailgun.class),
    AUTO_BOW(TurretAutoBow.class);

    private final Class<? extends Turret> clazz;
    private final String id;

    private TurretType(Class<? extends Turret> clazz) {
        this.clazz = clazz;
        this.id = LanguageUtility.toCamelCase((String)this.name());
    }

    public final String getId() {
        return this.id;
    }

    public static TurretType get(int id) {
        if (id >= 0 && id < TurretType.values().length) {
            return TurretType.values()[id];
        }
        return null;
    }

    public static TurretType get(String id) {
        for (TurretType type : TurretType.values()) {
            if (!id.endsWith(type.id)) continue;
            return type;
        }
        return null;
    }

    public static void load() {
        for (TurretType type : TurretType.values()) {
            if (type.id == null || type.clazz == null) continue;
            TurretRegistry.registerSentry(type.id, type.clazz);
        }
    }
}

