/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.ai;

import universalelectricity.api.vector.EulerAngle;

public class EulerServo
extends EulerAngle {
    public EulerAngle upperLimit = new EulerAngle(180.0, 40.0);
    public EulerAngle lowerLimit = new EulerAngle(-180.0, -40.0);
    private EulerAngle targetAngle = new EulerAngle();
    private double rotationSpeed;
    public boolean hasChanged = false;

    public EulerServo(double rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public EulerServo(EulerAngle angle, double rotationSpeed) {
        super(angle);
        this.rotationSpeed = rotationSpeed;
    }

    public EulerServo(double yaw, double pitch, double roll, double rotationSpeed) {
        super(yaw, pitch, roll);
        this.rotationSpeed = rotationSpeed;
    }

    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(double speed) {
        this.rotationSpeed = speed;
    }

    public EulerServo setLimit(EulerAngle upperLimit, EulerAngle lowerLimit) {
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
        return this;
    }

    public void update() {
        this.hasChanged = false;
        for (int i = 0; i < this.toArray().length; ++i) {
            if (!this.updateAngle(i)) continue;
            this.hasChanged = true;
        }
    }

    public boolean updateAngle(int index) {
        double prevAngle = this.toArray()[index];
        double currentAngle = this.toArray()[index];
        double targetAngle = this.targetAngle.toArray()[index];
        double upperLimit = this.upperLimit.toArray()[index];
        double lowerLimit = this.lowerLimit.toArray()[index];
        currentAngle = Math.abs(currentAngle - targetAngle) > this.rotationSpeed ? (Math.abs(currentAngle - targetAngle) >= 180.0 ? (currentAngle += currentAngle > targetAngle ? this.rotationSpeed : -this.rotationSpeed) : (currentAngle += currentAngle > targetAngle ? -this.rotationSpeed : this.rotationSpeed)) : targetAngle;
        currentAngle = EulerServo.clampAngleTo180((double)currentAngle);
        if (currentAngle > upperLimit) {
            currentAngle = upperLimit;
        } else if (currentAngle < lowerLimit) {
            currentAngle = lowerLimit;
        }
        this.set(index, currentAngle);
        return currentAngle != prevAngle;
    }

    public void setTargetRotation(EulerAngle targetRotation) {
        this.targetAngle = targetRotation;
    }

    public boolean isWithinLimit(EulerAngle compare) {
        for (int i = 0; i < compare.toArray().length; ++i) {
            if (!(compare.toArray()[i] > this.upperLimit.toArray()[i]) && !(compare.toArray()[i] < this.lowerLimit.toArray()[i])) continue;
            return false;
        }
        return true;
    }

    public EulerServo clone() {
        return new EulerServo(this.yaw, this.pitch, this.roll, this.getRotationSpeed());
    }
}

