/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.ai;

import icbm.sentry.interfaces.IAutoTurret;
import icbm.sentry.interfaces.ITurret;
import icbm.sentry.turret.Turret;
import icbm.sentry.turret.auto.TurretAuto;
import icbm.sentry.turret.traits.SentryTrait;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import universalelectricity.api.vector.EulerAngle;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class TurretAI {
    public boolean debugMode = false;
    private Turret turret;
    private int rotationDelayTimer = 0;
    private int targetLostTimer = 0;
    private int ticks = 0;
    private double search_range = 10.0;

    public TurretAI(Turret turret) {
        this.turret = turret;
    }

    public void debug(String str) {
        if (this.debugMode) {
            System.out.println("[Sentry AI] " + str);
        }
    }

    public TurretAuto turret() {
        if (this.turret != null && this.turret != null && this.turret instanceof IAutoTurret) {
            return (TurretAuto)this.turret;
        }
        return null;
    }

    public void update() {
        ++this.ticks;
        if (this.turret() != null) {
            this.search_range = SentryTrait.asDouble(this.turret().getTrait("ai.search.range"), 10.0);
            if (this.turret().getTarget() == null) {
                this.debug("\tSearching for target within " + this.search_range + " blocks");
                this.turret().setTarget(this.findTarget(this.turret(), this.turret().getEntitySelector(), this.search_range));
            }
            if (this.turret().getTarget() != null && this.isValidTarget(this.turret().getTarget(), false)) {
                if (this.canEntityBeSeen(this.turret().getTarget())) {
                    this.debug("\tTarget can be seen");
                    if (this.isLookingAt(this.turret().getTarget(), 3.0f)) {
                        if (this.turret().canFire()) {
                            this.debug("\tTarget locked and firing weapon");
                            this.turret().fire(this.turret().getTarget());
                        } else {
                            this.debug("\tTarget locked but weapon is not ready");
                        }
                    } else {
                        this.debug("\tPowering servos to aim at target");
                        this.lookAtEntity(this.turret().getTarget());
                    }
                    this.targetLostTimer = 0;
                } else {
                    this.debug("\tSight on target lost");
                    if (this.targetLostTimer >= 100) {
                        this.turret().setTarget(null);
                    }
                    ++this.targetLostTimer;
                }
            } else {
                this.debug("\tInvalid or null target");
                if (this.targetLostTimer >= 20) {
                    this.debug("\tTarget market as lost, resetting target");
                    if (this.rotationDelayTimer >= 60) {
                        this.debug("\tNo Target Selected. Wandering.");
                        this.rotationDelayTimer = 0;
                        Vector3 location = new Vector3(this.turret().x(), this.turret().y(), this.turret().z());
                        location.add((IVector3)new Vector3((double)(this.turret().world().field_73012_v.nextInt(40) - 20), 0.0, (double)(this.turret().world().field_73012_v.nextInt(40) - 20)));
                        this.lookAt(location);
                    }
                    this.turret().setTarget(null);
                    ++this.rotationDelayTimer;
                }
                ++this.targetLostTimer;
            }
        }
    }

    protected Entity findTarget(ITurret sentry, IEntitySelector targetSelector, double target_range) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.turret().fromCenter().x, (double)this.turret().fromCenter().y, (double)this.turret().fromCenter().z, (double)this.turret().fromCenter().x, (double)this.turret().fromCenter().y, (double)this.turret().fromCenter().z).func_72314_b(target_range, target_range, target_range);
        List list = this.turret().world().func_82733_a(Entity.class, aabb, targetSelector);
        Collections.sort(list, new ComparatorOptimalTarget((Vector3)this.turret().fromCenter()));
        this.debug("\t" + list.size() + "targets in range ");
        for (Entity entity : list) {
            this.debug("\t\tNext target " + entity.toString());
            if (!this.isValidTarget(entity, false)) continue;
            this.debug("\t\t\tValid");
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(Entity entity, boolean skipSight) {
        if (this.turret().getEntitySelector().func_82704_a(entity) && this.turret().fromCenter().distance(entity) <= this.search_range) {
            boolean bound_flag = this.isTargetInBounds(entity);
            boolean sight_flag = this.canEntityBeSeen(entity);
            this.debug("\t\tEntity: " + entity.toString() + " Sight: " + sight_flag + " Bounds:" + bound_flag);
            return skipSight || bound_flag && sight_flag;
        }
        return false;
    }

    public void lookAt(Vector3 target) {
        this.turret().getServo().setTargetRotation(this.turret().fromCenter().toAngle((IVector3)target));
    }

    public void lookAtEntity(Entity entity) {
        this.lookAt(Vector3.fromCenter((Entity)entity));
    }

    public boolean isTargetInBounds(Entity target) {
        return this.isTargetInBounds(Vector3.fromCenter((Entity)target));
    }

    public boolean isTargetInBounds(Vector3 target) {
        return this.isTargetInBounds((Vector3)this.turret().fromCenter(), target);
    }

    public boolean isTargetInBounds(Vector3 start, Vector3 target) {
        EulerAngle angle = start.toAngle((IVector3)target);
        return this.turret().getServo().isWithinLimit(angle);
    }

    public boolean isLookingAt(Vector3 target, float allowedError) {
        EulerAngle targetAngle = this.turret().fromCenter().toAngle((IVector3)target);
        return this.turret().getServo().isWithin(targetAngle, allowedError);
    }

    public boolean isLookingAt(Entity entity, float allowedError) {
        return this.isLookingAt(Vector3.fromCenter((Entity)entity), allowedError);
    }

    public boolean canEntityBeSeen(Entity entity) {
        Vector3 traceStart = this.turret().fromCenter().translate((IVector3)this.turret().getWeaponOffset());
        return this.canEntityBeSeen(traceStart, entity);
    }

    public boolean canEntityBeSeen(Vector3 traceStart, Entity entity) {
        MovingObjectPosition hitTarget = traceStart.clone().rayTrace(entity.field_70170_p, Vector3.fromCenter((Entity)entity), false);
        return hitTarget != null && entity.equals((Object)hitTarget.field_72308_g);
    }

    public MovingObjectPosition rayTrace(double distance) {
        Vector3 reach = new Vector3((IVector3)this.turret.getServo()).scale(distance);
        MovingObjectPosition hitTarget = this.turret.fromCenter().translate((IVector3)this.turret.getWeaponOffset()).rayTrace(this.turret.world(), reach, false);
        return hitTarget;
    }

    public static class ComparatorOptimalTarget
    implements Comparator<Entity> {
        private final Vector3 location;
        private boolean closest = true;

        public ComparatorOptimalTarget(Vector3 location) {
            this.location = location;
        }

        @Override
        public int compare(Entity entityA, Entity entityB) {
            if (this.closest) {
                Double distanceA = this.location.distance(entityA);
                Double distanceB = this.location.distance(entityB);
                return distanceA.compareTo(distanceB);
            }
            Double distanceB = this.location.distance(entityA);
            Double distanceA = this.location.distance(entityB);
            return distanceA.compareTo(distanceB);
        }
    }
}

