/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.ai;

import icbm.core.DamageUtility;
import icbm.sentry.interfaces.ITurret;
import icbm.sentry.interfaces.ITurretProvider;
import java.util.LinkedHashSet;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityOwnable;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonant.api.ai.ITarget;
import resonant.lib.access.IProfileContainer;
import resonant.lib.config.Config;
import resonant.lib.utility.nbt.ISaveObj;

public class TurretEntitySelector
implements IEntitySelector,
ISaveObj {
    ITurretProvider turretProvider;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_mobs_global = true;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_animals_global = false;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_npcs_global = true;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_players_global = true;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_flying_global = true;
    @Config(category="Sentry_AI_Targeting")
    public static boolean target_boss_global = false;
    public LinkedHashSet<String> targetting = new LinkedHashSet();

    public TurretEntitySelector(ITurret turret) {
        this.turretProvider = turret.getHost();
        this.targetting.add("mobs");
        this.targetting.add("animals");
        this.targetting.add("npcs");
        this.targetting.add("players");
        this.targetting.add("flying");
        this.targetting.add("boss");
    }

    public boolean canTargetType(String type) {
        return this.targetting.contains(type);
    }

    public void setTargetType(String type, boolean to) {
        if (to) {
            this.targetting.add(type);
        } else {
            this.targetting.remove(type);
        }
    }

    public boolean func_82704_a(Entity entity) {
        if (!this.isFriendly(entity) && this.isValid(entity)) {
            if (entity instanceof ITarget && ((ITarget)entity).canBeTargeted((Object)this.turretProvider.getTurret())) {
                return true;
            }
            if (entity instanceof EntityFlying) {
                return target_flying_global && this.canTargetType("flying");
            }
            if (entity instanceof IBossDisplayData) {
                return target_boss_global && this.canTargetType("boss");
            }
            if (entity instanceof EntityPlayer) {
                return target_players_global && this.canTargetType("players");
            }
            if (this.isMob(entity)) {
                return target_mobs_global && this.canTargetType("mobs");
            }
            if (entity instanceof IAnimals) {
                return target_animals_global && this.canTargetType("animals");
            }
            if (entity instanceof INpc) {
                return target_npcs_global && this.canTargetType("npcs");
            }
        }
        return false;
    }

    public boolean isMob(Entity entity) {
        return entity instanceof IMob;
    }

    public boolean isFriendly(Entity entity) {
        if (entity instanceof EntityPlayer) {
            if (this.turretProvider instanceof IProfileContainer) {
                return ((IProfileContainer)this.turretProvider).canAccess(((EntityPlayer)entity).field_71092_bJ);
            }
        } else if (entity instanceof EntityTameable && this.turretProvider instanceof EntityOwnable) {
            return ((IProfileContainer)this.turretProvider).canAccess(((EntityOwnable)entity).func_70905_p());
        }
        return false;
    }

    public boolean isValid(Entity entity) {
        if (DamageUtility.canDamage(entity)) {
            return !entity.func_82150_aj();
        }
        return false;
    }

    public void save(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (String string : this.targetting) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", string);
        }
        nbt.func_74782_a("targetList", (NBTBase)list);
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("targetList")) {
            NBTTagList list = nbt.func_74761_m("targetList");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTBase o = list.func_74743_b(i);
                if (!(o instanceof NBTTagCompound)) continue;
                this.targetting.add(((NBTTagCompound)o).func_74779_i("name"));
            }
        }
    }
}

