/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.auto;

import icbm.sentry.interfaces.IAutoTurret;
import icbm.sentry.interfaces.ITurretProvider;
import icbm.sentry.turret.Turret;
import icbm.sentry.turret.ai.TurretEntitySelector;
import icbm.sentry.turret.traits.SentryTrait;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.nbt.ISaveObj;

public abstract class TurretAuto
extends Turret
implements IAutoTurret {
    protected Entity target;
    protected IEntitySelector selector = new TurretEntitySelector(this);

    public TurretAuto(ITurretProvider host) {
        super(host);
    }

    @Override
    public void update() {
        super.update();
        if (!this.world().field_72995_K && this.getEnergy(ForgeDirection.UNKNOWN) >= SentryTrait.asLong(this.getTrait("body.energy.running"))) {
            this.getAi().update();
            this.getServo().update();
            this.setEnergy(ForgeDirection.UNKNOWN, this.getEnergy(ForgeDirection.UNKNOWN) - SentryTrait.asLong(this.getTrait("body.energy.running")));
        }
    }

    @Override
    public void setTarget(Entity target) {
        this.target = target;
        double r = SentryTrait.asDouble(this.getTrait(target != null ? "body.rotation.target" : "body.rotation"), 5.0);
        this.getServo().setRotationSpeed(r);
    }

    @Override
    public Entity getTarget() {
        return this.target;
    }

    @Override
    public IEntitySelector getEntitySelector() {
        return this.selector;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.selector instanceof ISaveObj) {
            NBTTagCompound targetTag = new NBTTagCompound();
            ((ISaveObj)this.selector).save(targetTag);
            nbt.func_74766_a("selector", targetTag);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.selector instanceof ISaveObj) {
            ((ISaveObj)this.selector).load(nbt.func_74775_l("selector"));
        }
    }
}

