/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.block;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.ICBMCore;
import icbm.sentry.interfaces.ITurretProvider;
import icbm.sentry.platform.TileTurretPlatform;
import icbm.sentry.turret.EntityMountableDummy;
import icbm.sentry.turret.Turret;
import icbm.sentry.turret.TurretRegistry;
import icbm.sentry.turret.TurretType;
import icbm.sentry.turret.mounted.TurretMounted;
import java.io.DataInput;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IExternalInventory;
import resonant.api.IExternalInventoryBox;
import resonant.api.IRotatable;
import resonant.lib.access.AccessProfile;
import resonant.lib.access.AccessUser;
import resonant.lib.access.IProfileContainer;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.terminal.TileTerminal;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class TileTurret
extends TileTerminal
implements IProfileContainer,
IRotatable,
IExternalInventory,
IBlockActivate,
ITurretProvider {
    protected static final int ROTATION_PACKET_ID = 3;
    protected static final int SENTRY_TYPE_PACKET_ID = 4;
    protected static final int DESCRIPTION_PACKET_ID = 5;
    protected static final int FIRING_EVENT_PACKET_ID = 6;
    protected static final int ENERGY_PACKET_ID = 7;
    protected static final int PROFILE_PACKET_ID = 8;
    protected static final int PROFILE_ADD_USER_PACKET_ID = 9;
    public EntityMountableDummy sentryEntity;
    protected AccessProfile accessProfile;
    protected Turret turret;
    private String unlocalizedName = "err";
    private String saveManagerSentryKey;
    private long turretPrevEnergy = 0L;

    public void func_70316_g() {
        super.func_70316_g();
        if (this.getTurret() != null) {
            this.getTurret().update();
            if (!this.field_70331_k.field_72995_K) {
                if (this.getTurret().getServo().hasChanged) {
                    PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)60.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.getRotationPacket());
                }
                if (this.turretPrevEnergy != this.getTurret().battery.getEnergy()) {
                    PacketHandler.sendPacketToClients((Packet)this.getEnergyPacket(), (World)this.func_70314_l());
                    this.turretPrevEnergy = this.getTurret().battery.getEnergy();
                }
            }
        }
    }

    public AccessProfile getAccessProfile() {
        if (this.accessProfile == null) {
            this.setAccessProfile(new AccessProfile().generateNew("default", (Object)this));
        }
        return this.accessProfile;
    }

    public void setAccessProfile(AccessProfile profile) {
        this.accessProfile = profile;
        if (profile != null) {
            profile.addContainer((IProfileContainer)this);
        }
    }

    public boolean canAccess(String username) {
        return this.getAccessProfile().getUserAccess(username).getGroup() != null;
    }

    public void onProfileChange() {
        PacketHandler.sendPacketToClients((Packet)this.getProfilePacket(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)60.0);
    }

    public Packet func_70319_e() {
        return this.getNBTPacket();
    }

    public Packet getNBTPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return ICBMCore.PACKET_TILE.getPacketWithID(2, (TileEntity)this, new Object[]{tag});
    }

    public Packet getTerminalPacket() {
        return ICBMCore.PACKET_TILE.getPacketWithID(1, (TileEntity)this, this.getPacketData(1).toArray());
    }

    public Packet getCommandPacket(String username, String cmdInput) {
        return ICBMCore.PACKET_TILE.getPacketWithID(0, (TileEntity)this, new Object[]{username, cmdInput});
    }

    public Packet getRotationPacket() {
        return ICBMCore.PACKET_TILE.getPacketWithID(3, (TileEntity)this, new Object[]{this.getTurret().getServo().yaw, this.getTurret().getServo().pitch});
    }

    public Packet getProfilePacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.getAccessProfile().save(tag);
        return ICBMCore.PACKET_TILE.getPacketWithID(8, (TileEntity)this, new Object[]{tag});
    }

    @Override
    public void sendFireEventToClient(IVector3 target) {
        PacketHandler.sendPacketToClients((Packet)ICBMCore.PACKET_TILE.getPacketWithID(6, (TileEntity)this, new Object[]{target}), (World)this.func_70314_l(), (IVector3)new Vector3((TileEntity)this), (double)100.0);
    }

    public Packet getEnergyPacket() {
        return ICBMCore.PACKET_TILE.getPacketWithID(7, (TileEntity)this, new Object[]{this.getTurret().getEnergy(ForgeDirection.UNKNOWN)});
    }

    public boolean onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        if (!super.onReceivePacket(id, data, player, extra)) {
            try {
                if (this.field_70331_k.field_72995_K) {
                    if (id == 5) {
                        this.turret = TurretRegistry.constructSentry(data.readUTF(), this);
                        this.getTurret().getServo().yaw = data.readDouble();
                        this.getTurret().getServo().pitch = data.readDouble();
                        return true;
                    }
                    if (id == 3) {
                        this.getTurret().getServo().yaw = data.readDouble();
                        this.getTurret().getServo().pitch = data.readDouble();
                        return true;
                    }
                    if (id == 6) {
                        this.getTurret().fire((IVector3)new Vector3(data));
                        return true;
                    }
                    if (id == 7) {
                        this.getTurret().setEnergy(ForgeDirection.UNKNOWN, data.readLong());
                        return true;
                    }
                    if (id == 8) {
                        this.getAccessProfile().load(PacketHandler.readNBTTagCompound((DataInput)data));
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public void setDirection(ForgeDirection direction) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, direction.ordinal(), 3);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagCompound perm_tag = new NBTTagCompound();
        this.getAccessProfile().save(perm_tag);
        nbt.func_74766_a("permissions", perm_tag);
        if (this.getTurret() != null) {
            NBTTagCompound sentrySave = new NBTTagCompound();
            this.getTurret().save(sentrySave);
            nbt.func_74766_a("sentryTile", sentrySave);
        }
        if (this.unlocalizedName != null && !this.unlocalizedName.isEmpty()) {
            nbt.func_74778_a("unlocalizedName", this.unlocalizedName);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.unlocalizedName = nbt.func_74779_i("unlocalizedName");
        if (nbt.func_74764_b("permissions")) {
            this.setAccessProfile(new AccessProfile(nbt.func_74775_l("permissions")));
        }
        if (nbt.func_74764_b("sentryTile")) {
            NBTTagCompound tag = nbt.func_74775_l("sentryTile");
            this.saveManagerSentryKey = tag.func_74779_i("sentryID");
            this.turret = TurretRegistry.constructSentry(this.saveManagerSentryKey, this);
            if (this.getTurret() != null) {
                this.getTurret().load(tag);
            }
        } else {
            this.saveManagerSentryKey = TurretType.GUN_TURRET.getId();
        }
    }

    public IExternalInventoryBox getInventory() {
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (tile instanceof TileTurretPlatform) {
            return ((TileTurretPlatform)tile).getInventory();
        }
        return null;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }

    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }

    @Override
    public Turret getTurret() {
        if (this.turret == null) {
            this.turret = TurretRegistry.constructSentry(this.saveManagerSentryKey, this);
        }
        return this.turret;
    }

    private static void debug(String str) {
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            if (!entityPlayer.func_70093_af()) {
                TileTurret.debug("right clicked, player is not sneaking");
                TileTurret.debug("is mountable " + (this.getTurret() instanceof TurretMounted));
                TileTurret.debug("is fake entity " + (this.getFakeEntity() != null));
                if (this.getTurret() instanceof TurretMounted && this.getFakeEntity() != null) {
                    TileTurret.debug("\t right clicked, turret is mountable and fake entity exists");
                    if (this.getFakeEntity().field_70153_n instanceof EntityPlayer) {
                        TileTurret.debug("right clicked, fake entity ridden by other entity");
                        if (!this.field_70331_k.field_72995_K) {
                            PacketHandler.sendPacketToClients((Packet)this.getRotationPacket());
                        }
                        return true;
                    }
                    this.mount(entityPlayer);
                }
            }
            return true;
        }
        return false;
    }

    public void mount(EntityPlayer entityPlayer) {
        TileTurret.debug("mounting...");
        if (!this.field_70331_k.field_72995_K) {
            TileTurret.debug("mounting on server");
            entityPlayer.field_70177_z = (float)this.getTurret().getServo().yaw;
            entityPlayer.field_70125_A = (float)this.getTurret().getServo().pitch;
            entityPlayer.func_70078_a((Entity)this.getFakeEntity());
        }
    }

    @Override
    public EntityMountableDummy getFakeEntity() {
        if ((this.sentryEntity == null || this.sentryEntity.field_70128_L) && !this.world().field_72995_K) {
            EntityMountableDummy entity = new EntityMountableDummy(this);
            this.world().func_72838_d((Entity)entity);
            this.setFakeEntity(entity);
        }
        return this.sentryEntity;
    }

    public void setFakeEntity(EntityMountableDummy entitySentryFake) {
        this.sentryEntity = entitySentryFake;
    }

    @Override
    public World world() {
        return this.func_70314_l();
    }

    @Override
    public double x() {
        return (double)this.field_70329_l + 0.5;
    }

    @Override
    public double y() {
        return (double)this.field_70330_m + 0.5;
    }

    @Override
    public double z() {
        return (double)this.field_70327_n + 0.5;
    }

    public boolean canUse(String node, EntityPlayer player) {
        AccessUser user = this.getAccessProfile().getUserAccess(player.field_71092_bJ);
        assert (user != null) : "TileTurret canUse() user returned null for player " + player.field_71092_bJ;
        if (user != null && user.getGroup() != null) {
            return this.getAccessProfile().getUserAccess(player.field_71092_bJ).hasNode(node);
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getTurret().onInventoryChanged();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 2), (double)(this.field_70330_m + 2), (double)(this.field_70327_n + 2));
    }
}

