/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.prefab.item.ItemICBMBase;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import resonant.api.weapon.IAmmunition;
import resonant.api.weapon.ProjectileType;
import resonant.lib.utility.inventory.InventoryUtility;

public class ItemAmmo
extends ItemICBMBase
implements IAmmunition {
    public static final Icon[] ICONS = new Icon[AmmoType.values().length];

    public ItemAmmo(int id) {
        super(id, "ammunition");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.icbm:" + AmmoType.values()[itemStack.func_77960_j()].iconName;
    }

    public Icon func_77617_a(int i) {
        return ICONS[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        for (int i = 0; i < AmmoType.values().length; ++i) {
            ItemAmmo.ICONS[i] = iconRegister.func_94245_a("icbm:" + AmmoType.values()[i].iconName);
        }
    }

    public ProjectileType getType(ItemStack itemStack) {
        if (itemStack.func_77960_j() < AmmoType.values().length) {
            return AmmoType.values()[itemStack.func_77960_j()].type;
        }
        return null;
    }

    public ItemStack onDroppedIntoWorld(ItemStack stack) {
        AmmoType type = AmmoType.get(stack);
        if (type == AmmoType.BULLET_INFINITE) {
            return null;
        }
        return stack;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        if (itemStack != null && itemStack.func_77960_j() == AmmoType.BULLET_INFINITE.ordinal()) {
            return 40;
        }
        return super.getEntityLifespan(itemStack, world);
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < AmmoType.values().length; ++i) {
            par3List.add(new ItemStack((Item)this, 1, i));
        }
    }

    public float getDamage() {
        return 8.0f;
    }

    public ItemStack consumeAmmo(ItemStack itemStack, int count) {
        AmmoType type = AmmoType.get(itemStack);
        if (type != null && type.consume) {
            return InventoryUtility.decrStackSize((ItemStack)itemStack, (int)count);
        }
        return itemStack;
    }

    public ItemStack getShell(ItemStack itemStack, int count) {
        AmmoType type = AmmoType.get(itemStack);
        if (type != AmmoType.SHELL && type != AmmoType.BULLET_INFINITE) {
            return new ItemStack((Item)this, count, AmmoType.SHELL.ordinal());
        }
        return null;
    }

    public int getAmmoCount(ItemStack itemStack) {
        if (AmmoType.get(itemStack) == AmmoType.BULLET_INFINITE) {
            return Integer.MAX_VALUE;
        }
        return itemStack.field_77994_a;
    }

    public static enum AmmoType {
        SHELL("bulletShell", ProjectileType.UNKNOWN, true),
        BULLET("bullet", ProjectileType.CONVENTIONAL, true),
        BULLET_RAIL("bulletRailgun", ProjectileType.RAILGUN, true),
        BULLET_ANTIMATTER("bulletAntimatter", ProjectileType.RAILGUN, true),
        BULLET_INFINITE("bulletInfinite", ProjectileType.CONVENTIONAL, false);

        public String iconName;
        public ProjectileType type;
        public boolean consume;

        private AmmoType(String iconName, ProjectileType type, boolean consume) {
            this.iconName = iconName;
            this.type = type;
            this.consume = consume;
        }

        public static AmmoType get(ItemStack itemStack) {
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemAmmo && itemStack.func_77960_j() < AmmoType.values().length) {
                return AmmoType.values()[itemStack.func_77960_j()];
            }
            return null;
        }
    }
}

