/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.prefab.item.ItemICBMBase;
import icbm.sentry.interfaces.ITurret;
import icbm.sentry.interfaces.IUpgrade;
import icbm.sentry.platform.TileTurretPlatform;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import resonant.lib.utility.LanguageUtility;

public class ItemSentryUpgrade
extends ItemICBMBase
implements IUpgrade {
    public ItemSentryUpgrade(int id) {
        super(id, "turretUpgrades");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(itemStack, player, list, par4);
        String local = LanguageUtility.getLocal((String)Upgrades.getDescription(itemStack.func_77960_j()));
        if (local != null && !local.isEmpty()) {
            list.addAll(LanguageUtility.splitStringPerWord((String)local, (int)4));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.icbm:" + Upgrades.values()[itemStack.func_77960_j()].name;
    }

    public Icon func_77617_a(int meta) {
        return Upgrades.getIcon(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        for (int meta = 0; meta < Upgrades.values().length; ++meta) {
            Upgrades.setIcon(meta, iconRegister.func_94245_a("icbm:" + Upgrades.values()[meta].iconName));
        }
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (int meta = 0; meta < Upgrades.values().length; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }

    @Override
    public void getTypes(List<String> types, ItemStack itemstack) {
        types.add(Upgrades.values()[itemstack.func_77960_j()].getUpgradeName());
    }

    @Override
    public double getUpgradeEfficiance(ItemStack itemstack, String type) {
        return Upgrades.values()[itemstack.func_77960_j()].bonus;
    }

    @Override
    public boolean canApplyTo(ItemStack itemStack, Object object) {
        if (itemStack != null && itemStack.func_77960_j() < Upgrades.values().length) {
            Upgrades upgrade = Upgrades.values()[itemStack.func_77960_j()];
            if (object instanceof ITurret && upgrade.getType() == Type.SENTRY) {
                return true;
            }
            if (object instanceof TileTurretPlatform && upgrade.getType() == Type.PLATFORM) {
                return true;
            }
        }
        return false;
    }

    public static enum Upgrades {
        TARGET_RANGE("targetRange", "target.range", 0.25, "info.upgrade.range"),
        COLLECTOR("shellCollector", "shellCollector", 1.0, "info.upgrade.collect"),
        SILENCER("silencer", "silencer", 1.0, "info.upgrade.silencer"),
        TARGET_SPEED("targetingSpeed", "target.speed", 1.0, "info.upgrade.targetspeed");

        public final String iconName;
        public final String name;
        public final String itemInfo;
        public Icon icon;
        private final String upgradeID;
        private final double bonus;
        private Type upgrade_type = Type.SENTRY;

        private Upgrades(String name, String upgradeName, double bonus, String info) {
            this(name, upgradeName, "upgrade." + name, bonus, info);
        }

        private Upgrades(String name, String upgradeName, String texture, double bonus, String info) {
            this.name = name;
            this.iconName = texture;
            this.itemInfo = info;
            this.upgradeID = upgradeName;
            this.bonus = bonus;
        }

        public String getUpgradeName() {
            return this.upgradeID;
        }

        public double getBonus() {
            return this.bonus;
        }

        public Type getType() {
            return this.upgrade_type;
        }

        public Icon icon() {
            return this.icon;
        }

        public static Icon getIcon(int meta) {
            if (meta >= 0 && meta < Upgrades.values().length) {
                return Upgrades.values()[meta].icon();
            }
            return null;
        }

        public static void setIcon(int meta, Icon icon) {
            if (meta >= 0 && meta < Upgrades.values().length) {
                Upgrades.values()[meta].icon = icon;
            }
        }

        public static String getDescription(int meta) {
            if (meta < Upgrades.values().length) {
                return "" + Upgrades.values()[meta].itemInfo;
            }
            return LanguageUtility.getLocal((String)"info.upgrade.sentry");
        }
    }

    public static enum Type {
        SENTRY,
        PLATFORM,
        MOBILESENTRY;

    }
}

