/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon;

import icbm.sentry.interfaces.ITurret;
import icbm.sentry.weapon.WeaponDamage;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import resonant.lib.prefab.damage.ObjectDamageSource;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class WeaponInaccuracy
extends WeaponDamage {
    protected float inaccuracy = 5.0E-5f;
    protected float min_range = 1.0f;
    protected float max_range = 100.0f;

    public WeaponInaccuracy(ITurret sentry, int ammoAmount, float damage) {
        super(sentry, (DamageSource)ObjectDamageSource.doBulletDamage((Object)sentry), damage);
        this.itemsConsumedPerShot = ammoAmount;
    }

    public WeaponInaccuracy(Entity player, int ammoAmount, float damage) {
        super(player, DamageSource.field_82728_o, damage);
        this.itemsConsumedPerShot = ammoAmount;
    }

    @Override
    public void fire(IVector3 t) {
        Vector3 target = new Vector3(t);
        double d = target.distance((IVector3)this.turret());
        super.fire((IVector3)target.translate(this.getInaccuracy(d), this.getInaccuracy(d), this.getInaccuracy(d)));
        this.consumeAmmo(this.itemsConsumedPerShot, true);
    }

    protected double getInaccuracy(double distance) {
        double offset = distance * (double)(this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * (double)this.inaccuracy;
        if (distance < (double)this.min_range || distance > (double)this.max_range) {
            return offset * 2.0;
        }
        return offset;
    }
}

