/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon;

import icbm.sentry.interfaces.ITurret;
import icbm.sentry.interfaces.ITurretProvider;
import icbm.sentry.interfaces.IWeaponSystem;
import icbm.sentry.weapon.EntityTurret;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IExternalInventory;
import resonant.api.weapon.IAmmunition;
import resonant.api.weapon.ProjectileType;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.api.vector.IRotation;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.IVectorWorld;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public abstract class WeaponSystem
implements IWeaponSystem,
IVectorWorld,
IRotation {
    private IVectorWorld host_vector = null;
    private Entity host_entity = null;
    private TileEntity host_tile = null;
    protected float rayTraceLimit = 100.0f;
    protected int itemsConsumedPerShot = 0;
    public Vector3 aimOffset = new Vector3();
    protected IInventory inventory = null;
    public String soundEffect = null;

    public WeaponSystem(IVectorWorld pos) {
        this.host_vector = pos;
    }

    public WeaponSystem(TileEntity tile) {
        this.host_tile = tile;
    }

    public WeaponSystem(Entity entity) {
        this.host_entity = entity;
    }

    public void setHost(VectorWorld placement) {
        this.host_vector = placement;
    }

    public void setHost(TileEntity host) {
        this.host_tile = host;
    }

    public void setHost(Entity host) {
        this.host_entity = host;
    }

    public World world() {
        if (this.host_entity != null) {
            return this.host_entity.field_70170_p;
        }
        if (this.host_tile != null) {
            return this.host_tile.func_70314_l();
        }
        return this.host_vector.world();
    }

    public double x() {
        if (this.host_entity != null) {
            return this.host_entity.field_70165_t;
        }
        if (this.host_tile != null) {
            return (double)this.host_tile.field_70329_l + 0.5;
        }
        return this.host_vector.x();
    }

    public double y() {
        if (this.host_entity != null) {
            return this.host_entity.field_70163_u;
        }
        if (this.host_tile != null) {
            return (double)this.host_tile.field_70330_m + 0.5;
        }
        return this.host_vector.y();
    }

    public double z() {
        if (this.host_entity != null) {
            return this.host_entity.field_70161_v;
        }
        if (this.host_tile != null) {
            return (double)this.host_tile.field_70327_n + 0.5;
        }
        return this.host_vector.z();
    }

    public double yaw() {
        if (this.turret() != null) {
            return this.turret().yaw();
        }
        if (this.host_entity != null) {
            return this.host_entity.field_70177_z;
        }
        return 0.0;
    }

    public double pitch() {
        if (this.turret() != null) {
            return this.turret().pitch();
        }
        if (this.host_entity != null) {
            return this.host_entity.field_70125_A;
        }
        return 0.0;
    }

    public double roll() {
        return 0.0;
    }

    @Override
    public void fire(double range) {
        this.fire((IVector3)new Vector3(this.x(), this.y(), this.z()).translate((IVector3)this.turret().getWeaponOffset().scale(range)));
    }

    @Override
    public void fire(IVector3 target) {
        this.playFiringAudio();
        this.doFire(target);
    }

    @Override
    public void fire(Entity entity) {
        this.fire((IVector3)Vector3.fromCenter((Entity)entity));
    }

    protected void playFiringAudio() {
        if (this.soundEffect != null && !this.soundEffect.isEmpty()) {
            this.world().func_72908_a(this.x(), this.y(), this.z(), this.soundEffect, 5.0f, 1.0f - this.world().field_73012_v.nextFloat() * 0.2f);
        }
    }

    @Override
    public void fireClient(IVector3 hit) {
    }

    public void drawParticleStreamTo(World world, Vector3 start, IVector3 hit) {
        double scale = 0.02;
        Vector3 currentPoint = start.clone();
        Vector3 difference = new Vector3(hit).difference((IVector3)start);
        while (currentPoint.distance(hit) > scale) {
            world.func_72869_a("townaura", currentPoint.x, currentPoint.y, currentPoint.z, 0.0, 0.0, 0.0);
            currentPoint.add((IVector3)difference.clone().scale(scale));
        }
    }

    protected Vector3 getBarrelEnd() {
        if (this.turret() != null) {
            return new Vector3(this.x(), this.y(), this.z()).translate((IVector3)this.turret().getWeaponOffset());
        }
        return new Vector3(this.x(), this.y(), this.z()).translate((IVector3)this.aimOffset);
    }

    protected abstract void doFire(IVector3 var1);

    protected abstract void onHitEntity(Entity var1);

    protected abstract void onHitBlock(Vector3 var1);

    @Override
    public boolean isAmmo(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IAmmunition && ((IAmmunition)stack.func_77973_b()).getType(stack) != ProjectileType.UNKNOWN;
    }

    @Override
    public boolean canFire() {
        return this.itemsConsumedPerShot <= 0 || this.consumeAmmo(this.itemsConsumedPerShot, false);
    }

    public boolean consumeAmmo(int count, boolean doConsume) {
        int consumeCount = 0;
        int need = count;
        if (count > 0 && this.getAmmoBay() != null) {
            for (int slot = 0; slot < this.getAmmoBay().func_70302_i_(); ++slot) {
                ItemStack itemStack = this.getAmmoBay().func_70301_a(slot);
                if (!this.isAmmo(itemStack)) continue;
                int ammo_count = itemStack.field_77994_a;
                if (itemStack.func_77973_b() instanceof IAmmunition) {
                    ammo_count = ((IAmmunition)itemStack.func_77973_b()).getAmmoCount(itemStack);
                }
                if (ammo_count >= need) {
                    if (doConsume) {
                        this.getAmmoBay().func_70299_a(slot, this.doConsumeAmmo(itemStack, need));
                    }
                    return true;
                }
                int consume = need - (need - ammo_count);
                if (doConsume) {
                    this.getAmmoBay().func_70299_a(slot, this.doConsumeAmmo(itemStack, consume));
                }
                need -= consume;
                consumeCount += ammo_count;
            }
        }
        return consumeCount >= count;
    }

    protected ItemStack doConsumeAmmo(ItemStack stack, int sum) {
        if (stack != null && sum > 0) {
            if (!(stack.func_77973_b() instanceof IAmmunition)) {
                ItemStack splitStack = stack.func_77979_a(stack.field_77994_a - 1);
                if (stack != null && stack.field_77994_a > 0) {
                    return splitStack;
                }
            } else {
                IAmmunition ammo = (IAmmunition)stack.func_77973_b();
                ItemStack shell = ammo.getShell(stack, sum);
                ItemStack ammo_left = ammo.consumeAmmo(stack, sum);
                if (this.turret() != null && shell != null) {
                    if (this.turret().upgrades().containsKey("shellCollector")) {
                        shell = InventoryUtility.putStackInInventory((IInventory)this.getAmmoBay(), (ItemStack)shell, (int)ForgeDirection.UNKNOWN.ordinal(), (boolean)true);
                    }
                    if (shell != null) {
                        InventoryUtility.dropItemStack((World)this.world(), (double)this.x(), (double)this.y(), (double)this.z(), (ItemStack)shell, (int)5, (float)0.0f);
                    }
                }
                if (ammo_left != null && ammo_left.field_77994_a > 0) {
                    return ammo_left;
                }
                return null;
            }
        }
        return stack;
    }

    public ITurret turret() {
        if (this.asTurret(this.host_entity) != null) {
            return this.asTurret(this.host_entity);
        }
        if (this.asTurret(this.host_tile) != null) {
            return this.asTurret(this.host_tile);
        }
        if (this.asTurret(this.host_vector) != null) {
            return this.asTurret(this.host_vector);
        }
        return null;
    }

    public IInventory getAmmoBay() {
        if (this.inventory == null) {
            if (this.asInv(this.host_entity) != null) {
                this.inventory = this.asInv(this.host_entity);
            } else if (this.asInv(this.host_tile) != null) {
                this.inventory = this.asInv(this.host_tile);
            } else if (this.asInv(this.host_vector) != null) {
                this.inventory = this.asInv(this.host_vector);
            }
        }
        return this.inventory;
    }

    public ITurret asTurret(Object object) {
        if (object instanceof ITurret) {
            return (ITurret)object;
        }
        if (object instanceof ITurretProvider) {
            return ((ITurretProvider)object).getTurret();
        }
        if (object instanceof Entity) {
            return new EntityTurret((Entity)object);
        }
        return null;
    }

    public IInventory asInv(Object object) {
        if (object instanceof IInventory) {
            return (IInventory)object;
        }
        if (this.asTurret(object) != null) {
            if (this.asTurret(object).getHost() instanceof IExternalInventory) {
                return ((IExternalInventory)this.asTurret(object).getHost()).getInventory();
            }
            if (this.asTurret(object).getHost() instanceof IInventory) {
                return (IInventory)this.asTurret(object).getHost();
            }
        }
        return null;
    }
}

