/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon;

import icbm.sentry.turret.ai.EulerServo;
import icbm.sentry.weapon.WeaponSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.IVectorWorld;
import universalelectricity.api.vector.Vector3;

public abstract class WeaponThrowable
extends WeaponSystem {
    protected EulerServo servo = new EulerServo(5.0);

    public WeaponThrowable(IVectorWorld loc) {
        super(loc);
    }

    public WeaponThrowable(Entity entity) {
        super(entity);
    }

    public WeaponThrowable(TileEntity tile) {
        super(tile);
    }

    @Override
    protected void playFiringAudio() {
        this.world().func_72926_e(1002, (int)this.x(), (int)this.y(), (int)this.z(), 0);
    }

    @Override
    protected void doFire(IVector3 target) {
        Vector3 end = this.getBarrelEnd();
        this.servo.set(0, this.yaw());
        this.servo.set(1, this.pitch());
        Vector3 vel = new Vector3((IVector3)this.servo).scale((double)this.getVelocity());
        IProjectile projectile = this.getProjectileEntity(this.world(), end.x(), end.y(), end.z());
        if (projectile instanceof Entity) {
            projectile.func_70186_c(vel.x(), vel.y(), vel.z(), 1.0f, this.getSpread());
            this.world().func_72838_d((Entity)projectile);
            this.consumeAmmo(this.itemsConsumedPerShot, true);
            this.playFiringAudio();
        }
    }

    @Override
    protected void onHitEntity(Entity entity) {
    }

    @Override
    protected void onHitBlock(Vector3 block) {
    }

    protected abstract IProjectile getProjectileEntity(World var1, double var2, double var4, double var6);

    protected float getSpread() {
        return 6.0f;
    }

    protected float getVelocity() {
        return 1.1f;
    }
}

