/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon.guns;

import icbm.sentry.weapon.guns.HandAmmunitionHandler;
import icbm.sentry.weapon.guns.ItemWeapon;
import icbm.sentry.weapon.guns.WeaponContent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class ItemConventional
extends ItemWeapon {
    public int gunDamage;
    private int capacity;

    public ItemConventional(int id, String name, WeaponContent wc) {
        super(id, name, wc);
        this.gunDamage = wc.getDamage();
        this.capacity = wc.getCapacity();
        this.func_77625_d(1);
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (itemstack.field_77990_d == null) {
            itemstack.field_77990_d = new NBTTagCompound();
            itemstack.field_77990_d.func_74768_a("clipCapacity", this.capacity);
            itemstack.field_77990_d.func_74768_a("clipCurrentAmmo", 0);
        }
        return super.func_77659_a(itemstack, world, player);
    }

    @Override
    public void onHitEntity(World world, EntityPlayer shooter, Entity entityHit) {
        DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)shooter);
        entityHit.func_70097_a(damageSource, (float)this.gunDamage);
    }

    @Override
    public void onHitBlock(World world, EntityPlayer shooter, Vector3 hitVec) {
        if (world.func_72798_a(hitVec.intX(), hitVec.intY(), hitVec.intZ()) == Block.field_71946_M.field_71990_ca || world.func_72798_a(hitVec.intX(), hitVec.intY(), hitVec.intZ()) == Block.field_72003_bq.field_71990_ca) {
            world.func_94571_i(hitVec.intX(), hitVec.intY(), hitVec.intZ());
            world.func_72908_a((double)hitVec.intX(), (double)hitVec.intY(), (double)hitVec.intZ(), "minecraft:random.glass", 5.0f, 1.0f);
        }
    }

    @Override
    public void onPreWeaponFired(ItemStack stack, World world, EntityPlayer shooter) {
    }

    @Override
    public void onPostWeaponFired(ItemStack stack, World world, EntityPlayer shooter) {
        if (!world.field_72995_K && !HandAmmunitionHandler.isEmpty(shooter, stack)) {
            HandAmmunitionHandler.consume(stack, 1);
        }
    }

    @Override
    public void onSneakClick(ItemStack stack, World world, EntityPlayer shooter) {
        if (HandAmmunitionHandler.isEmpty(shooter, stack) && HandAmmunitionHandler.searchInventoryForAmmo(shooter, false) != null) {
            HandAmmunitionHandler.searchInventoryForAmmo(shooter, true);
            if (!world.field_72995_K) {
                HandAmmunitionHandler.reload(stack);
            }
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        list.add("Damage Per Shot: " + this.gunDamage);
        list.add("Ammo: " + HandAmmunitionHandler.getCurrentAmmo(itemStack) + "/" + this.capacity);
        super.func_77624_a(itemStack, entityPlayer, list, par4);
    }

    @Override
    public void onRender(World world, EntityPlayer player, Vector3 hit) {
        this.drawParticleStreamTo(world, new Vector3((Entity)player), (IVector3)hit);
    }
}

