/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon.guns;

import icbm.core.prefab.item.ItemICBMBase;
import icbm.sentry.weapon.guns.HandAmmunitionHandler;
import icbm.sentry.weapon.guns.WeaponContent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import resonant.lib.prefab.vector.RayTraceHelper;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public abstract class ItemWeapon
extends ItemICBMBase {
    protected int blockRange = 150;
    protected String soundEffect;
    protected final int bps;
    protected final int cooldown;
    protected final double inaccuracy;
    protected float min_range = 1.0f;
    protected float max_range = 100.0f;

    public ItemWeapon(int id, String name, WeaponContent wc) {
        super(id, name);
        this.cooldown = wc.getCooldown();
        this.inaccuracy = wc.getInaccuracy();
        this.soundEffect = wc.getSoundname();
        this.bps = wc.getBulletsPerShot();
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity par3Entity, int par4, boolean par5) {
        if (!world.field_72995_K && this.getCooldownTicks(itemstack) > 0) {
            itemstack.func_77978_p().func_74768_a("cooldownTicks", this.getCooldownTicks(itemstack) - 1);
        }
        super.func_77663_a(itemstack, world, par3Entity, par4, par5);
    }

    public int getCooldownTicks(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("cooldownTicks")) {
            return stack.func_77978_p().func_74762_e("cooldownTicks");
        }
        return 0;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
            itemstack.func_77978_p().func_74768_a("cooldownTicks", 0);
        }
        if (player.func_70093_af()) {
            this.onSneakClick(itemstack, world, player);
            return itemstack;
        }
        if (this.getCooldownTicks(itemstack) <= 0) {
            for (int i = 0; i < this.bps; ++i) {
                this.onPreWeaponFired(itemstack, world, player);
                if (HandAmmunitionHandler.isEmpty(player, itemstack)) continue;
                this.onWeaponFired(itemstack, world, player);
                this.onPostWeaponFired(itemstack, world, player);
            }
            itemstack.func_77978_p().func_74768_a("cooldownTicks", this.cooldown);
        }
        return itemstack;
    }

    public void drawParticleStreamTo(World world, Vector3 start, IVector3 hit) {
        double scale = 0.02;
        Vector3 currentPoint = start.clone();
        Vector3 difference = new Vector3(hit).difference((IVector3)start);
        while (currentPoint.distance(hit) > scale) {
            world.func_72869_a("smoke", currentPoint.x, currentPoint.y, currentPoint.z, 0.0, 0.0, 0.0);
            currentPoint.add((IVector3)difference.clone().scale(scale));
        }
    }

    public boolean canFireWeapon(ItemStack itemstack, World world, EntityPlayer player, int rounds) {
        return true;
    }

    public abstract void onRender(World var1, EntityPlayer var2, Vector3 var3);

    public abstract void onSneakClick(ItemStack var1, World var2, EntityPlayer var3);

    public abstract void onPreWeaponFired(ItemStack var1, World var2, EntityPlayer var3);

    public abstract void onPostWeaponFired(ItemStack var1, World var2, EntityPlayer var3);

    public void onWeaponFired(ItemStack weaponStack, World world, EntityPlayer player) {
        Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 playerLook = RayTraceHelper.getLook((Entity)player, (float)1.0f);
        Vec3 p = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a), (double)(playerPosition.field_72448_b + playerLook.field_72448_b), (double)(playerPosition.field_72449_c + playerLook.field_72449_c));
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * (double)this.blockRange), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * (double)this.blockRange), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * (double)this.blockRange));
        MovingObjectPosition hit = RayTraceHelper.do_rayTraceFromEntity((Entity)player, (Vec3)new Vector3().translate(this.getInaccuracy(world, this.inaccuracy)).toVec3(), (double)this.blockRange, (boolean)true);
        if (hit != null) {
            if (hit.field_72313_a == EnumMovingObjectType.ENTITY && hit.field_72308_g != null) {
                this.onHitEntity(world, player, hit.field_72308_g);
                this.onRender(world, player, new Vector3(hit.field_72308_g));
            } else if (hit.field_72313_a == EnumMovingObjectType.TILE) {
                this.onHitBlock(world, player, new Vector3(hit.field_72307_f));
                this.onRender(world, player, new Vector3(hit.field_72307_f));
            }
            this.playSoundEffect(player);
            playerViewOffset = hit.field_72307_f;
            float x = (float)((double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 - (double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
            float z = (float)((double)MathHelper.func_76126_a((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.4 + (double)MathHelper.func_76134_b((float)((float)((double)player.field_70759_as * 0.0174532925))) * -0.1);
        }
    }

    protected double getInaccuracy(World world, double distance) {
        double offset = distance * (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * this.inaccuracy;
        if (distance < (double)this.min_range || distance > (double)this.max_range) {
            return offset * 2.0;
        }
        return offset;
    }

    public abstract void onHitEntity(World var1, EntityPlayer var2, Entity var3);

    public abstract void onHitBlock(World var1, EntityPlayer var2, Vector3 var3);

    public void playSoundEffect(EntityPlayer player) {
        if (this.soundEffect != null && !this.soundEffect.isEmpty()) {
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, this.soundEffect, 5.0f, 1.0f);
        }
    }
}

