/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon.types;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.sentry.ICBMSentry;
import icbm.sentry.interfaces.IEnergyWeapon;
import icbm.sentry.interfaces.ITurret;
import icbm.sentry.weapon.WeaponDamage;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import resonant.lib.prefab.damage.ObjectDamageSource;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.vector.IVector3;

public class WeaponLaser
extends WeaponDamage
implements IEnergyWeapon {
    private long energy;

    public WeaponLaser(ITurret sentry, float damage, long energy) {
        this(sentry, damage);
        this.soundEffect = "icbm:lasershot";
        this.energy = energy;
    }

    public WeaponLaser(ITurret sentry, float damage) {
        super(sentry, (DamageSource)ObjectDamageSource.doLaserDamage((Object)sentry), damage);
    }

    @Override
    public void fire(Entity entity) {
        this.onHitEntity(entity);
        this.playFiringAudio();
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (entity != null) {
            super.onHitEntity(entity);
            entity.func_70015_d(5);
        }
    }

    @Override
    public void fire(IVector3 target) {
        this.playFiringAudio();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void fireClient(IVector3 hit) {
        ICBMSentry.proxy.renderBeam(this.world(), (IVector3)this.getBarrelEnd(), hit, 1.0f, 1.0f, 1.0f, 10);
    }

    @Override
    public boolean isAmmo(ItemStack stack) {
        return stack != null && CompatibilityModule.isHandler((Object)stack.func_77973_b());
    }

    @Override
    public boolean consumeAmmo(int sum, boolean yes) {
        return true;
    }

    @Override
    public long getEnergyPerShot() {
        return this.energy;
    }
}

