/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.weapon.types;

import icbm.sentry.interfaces.IEnergyWeapon;
import icbm.sentry.interfaces.ITurret;
import icbm.sentry.weapon.WeaponInaccuracy;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import resonant.api.weapon.IAmmunition;
import resonant.api.weapon.ProjectileType;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class WeaponRailgun
extends WeaponInaccuracy
implements IEnergyWeapon {
    private long energy = 100000L;

    public WeaponRailgun(ITurret sentry) {
        this(sentry, 100.0f);
    }

    public WeaponRailgun(ITurret sentry, float damage) {
        super(sentry, 1, damage);
    }

    public WeaponRailgun(ITurret sentry, float damage, long energy) {
        this(sentry, damage);
        this.energy = energy;
    }

    @Override
    public void onHitEntity(Entity entity) {
        super.onHitEntity(entity);
        this.onHitBlock(Vector3.fromCenter((Entity)entity));
    }

    @Override
    public void onHitBlock(Vector3 hit) {
        int size = 10;
        this.world().func_72885_a((Entity)null, hit.x, hit.y, hit.z, (float)size, true, true);
        Block block = Block.field_71973_m[this.world().func_72798_a(hit.intX(), hit.intY(), hit.intZ())];
        if (block != null) {
            if (block.func_71934_m(this.world(), hit.intX(), hit.intY(), hit.intZ()) >= 0.0f) {
                return;
            }
            if (block.func_71934_m(this.world(), hit.intX(), hit.intY(), hit.intZ()) < 100000.0f) {
                this.world().func_94571_i(hit.intX(), hit.intY(), hit.intZ());
            }
        }
    }

    @Override
    public boolean isAmmo(ItemStack stack) {
        return super.isAmmo(stack) && ((IAmmunition)stack.func_77973_b()).getType(stack) == ProjectileType.RAILGUN;
    }

    @Override
    public void fire(IVector3 t) {
        Vector3 target = new Vector3(t);
        double d = target.distance((IVector3)this.turret().fromCenter());
        Vector3 normalized = target.clone().subtract((IVector3)this.turret().fromCenter()).normalize();
        target.translate((IVector3)normalized.scale(8.0));
        for (int i = 0; i < 5; ++i) {
            this.doFire((IVector3)target.clone().translate(this.getInaccuracy(d), this.getInaccuracy(d), this.getInaccuracy(d)));
        }
        this.consumeAmmo(this.itemsConsumedPerShot, true);
    }

    @Override
    public long getEnergyPerShot() {
        return this.energy;
    }
}

