/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class CertificateHelper {
    private static final String HEXES = "0123456789abcdef";

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "NO VALID CERTIFICATE FOUND";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return CertificateHelper.hexify(digest);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFingerprint(ByteBuffer buffer) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(buffer);
            byte[] chksum = digest.digest();
            return CertificateHelper.hexify(chksum);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String hexify(byte[] chksum) {
        StringBuilder hex = new StringBuilder(2 * chksum.length);
        for (byte b2 : chksum) {
            hex.append(HEXES.charAt((b2 & 0xF0) >> 4)).append(HEXES.charAt(b2 & 0xF));
        }
        return hex.toString();
    }
}

