/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.belt;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IEntityConveyor;
import resonant.api.IRotatable;
import resonant.lib.content.module.TileBase;
import resonant.lib.network.IPacketReceiverWithID;
import resonantinduction.core.ResonantInduction;
import resonantinduction.mechanical.Mechanical;

public class TileConveyorBelt
extends TileBase
implements IEntityConveyor,
IRotatable,
IPacketReceiverWithID {
    public static final int MAX_FRAME = 13;
    public static final int MAX_SLANT_FRAME = 23;
    public static final int PACKET_SLANT = 0;
    public static final int PACKET_REFRESH = 1;
    public static final float ACCELERATION = 0.1f;
    private int animationFrame = 0;
    private BeltType slantType = BeltType.NORMAL;
    public List<Entity> ignoreList = new ArrayList<Entity>();
    private boolean markRefresh = true;

    public TileConveyorBelt() {
        super(Material.field_76243_f);
    }

    public void func_70316_g() {
        super.func_70316_g();
        Iterator<Entity> it = this.ignoreList.iterator();
        List<Entity> effect_list = this.getAffectedEntities();
        while (it.hasNext()) {
            if (effect_list.contains(it.next())) continue;
            it.remove();
        }
        if (this.field_70331_k.field_72995_K) {
            if (this.ticks % 10L == 0L && this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) != Mechanical.blockConveyorBelt.field_71990_ca && this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) != Mechanical.blockConveyorBelt.field_71990_ca) {
                this.field_70331_k.func_72980_b((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "resonantinduction:conveyor", 0.5f, 0.65f, true);
            }
            ++this.animationFrame;
            if (this.getBeltType() == BeltType.NORMAL || this.getBeltType() == BeltType.RAISED) {
                if (this.animationFrame < 0) {
                    this.animationFrame = 0;
                }
                if (this.animationFrame > 13) {
                    this.animationFrame = 0;
                }
            } else {
                if (this.animationFrame < 0) {
                    this.animationFrame = 0;
                }
                if (this.animationFrame > 23) {
                    this.animationFrame = 0;
                }
            }
        } else if (this.markRefresh) {
            this.sendRefreshPacket();
            this.markRefresh = false;
        }
    }

    public Packet func_70319_e() {
        if (this.getBeltType() != BeltType.NORMAL) {
            return ResonantInduction.PACKET_TILE.getPacketWithID(0, (TileEntity)this, new Object[]{this.getBeltType().ordinal()});
        }
        return super.func_70319_e();
    }

    public void sendRefreshPacket() {
    }

    public boolean onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        if (this.field_70331_k.field_72995_K) {
            if (id == 0) {
                this.setBeltType(BeltType.values()[data.readInt()]);
                return true;
            }
            if (id == 1) {
                return true;
            }
        }
        return false;
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, facingDirection.ordinal(), 3);
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    public List<Entity> getAffectedEntities() {
        return this.field_70331_k.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1)));
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setBeltType(BeltType.values()[nbt.func_74771_c("slant")]);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("slant", (byte)this.getBeltType().ordinal());
    }

    public void ignoreEntity(Entity entity) {
        if (!this.ignoreList.contains(entity)) {
            this.ignoreList.add(entity);
        }
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public BeltType getBeltType() {
        return this.slantType;
    }

    public void setBeltType(BeltType slantType) {
        if (slantType == null) {
            slantType = BeltType.NORMAL;
        }
        this.slantType = slantType;
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public static enum BeltType {
        NORMAL,
        SLANT_UP,
        SLANT_DOWN,
        RAISED;

    }
}

