/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.grid;

import codechicken.multipart.TMultiPart;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.Node;
import resonant.lib.grid.TickingGrid;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.Vector3;

public class MechanicalNode
extends Node<INodeProvider, TickingGrid, MechanicalNode>
implements IMechanicalNode {
    public double torque = 0.0;
    public double prevAngularVelocity;
    public double angularVelocity = 0.0;
    public float acceleration = 2.0f;
    public double angle = 0.0;
    public double prev_angle = 0.0;
    protected double maxDeltaAngle = Math.toRadians(180.0);
    protected double load = 2.0;
    protected byte connectionMap = Byte.parseByte("111111", 2);
    private double power = 0.0;

    public MechanicalNode(INodeProvider parent) {
        super(parent);
    }

    public MechanicalNode setLoad(double load) {
        this.load = load;
        return this;
    }

    public MechanicalNode setConnection(byte connectionMap) {
        this.connectionMap = connectionMap;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float deltaTime) {
        this.prevAngularVelocity = this.angularVelocity;
        if (!ResonantInduction.proxy.isPaused()) {
            this.angle = this.angularVelocity >= 0.0 ? (this.angle += Math.min(this.angularVelocity, this.maxDeltaAngle) * (double)deltaTime) : (this.angle += Math.max(this.angularVelocity, -this.maxDeltaAngle) * (double)deltaTime);
        }
        if (this.angle % (Math.PI * 2) != this.angle) {
            this.revolve();
            this.angle %= Math.PI * 2;
        }
        if (this.world() != null && !this.world().field_72995_K) {
            double acceleration = this.acceleration * deltaTime;
            double torqueLoss = Math.min(Math.abs(this.getTorque()), (Math.abs(this.getTorque() * this.getTorqueLoad()) + this.getTorqueLoad() / 10.0) * (double)deltaTime);
            this.torque = this.torque > 0.0 ? (this.torque -= torqueLoss) : (this.torque += torqueLoss);
            double velocityLoss = Math.min(Math.abs(this.getAngularVelocity()), (Math.abs(this.getAngularVelocity() * this.getAngularVelocityLoad()) + this.getAngularVelocityLoad() / 10.0) * (double)deltaTime);
            this.angularVelocity = this.angularVelocity > 0.0 ? (this.angularVelocity -= velocityLoss) : (this.angularVelocity += velocityLoss);
            if (this.getEnergy() <= 0.0) {
                this.torque = 0.0;
                this.angularVelocity = 0.0;
            }
            this.power = this.getEnergy() / (double)deltaTime;
            AbstractMap abstractMap = this.connections;
            synchronized (abstractMap) {
                for (Map.Entry entry : this.connections.entrySet()) {
                    ForgeDirection dir = (ForgeDirection)entry.getValue();
                    MechanicalNode adjacentMech = (MechanicalNode)((Object)entry.getKey());
                    float ratio = adjacentMech.getRatio(dir.getOpposite(), this) / this.getRatio(dir, adjacentMech);
                    boolean inverseRotation = this.inverseRotation(dir, adjacentMech) && adjacentMech.inverseRotation(dir.getOpposite(), this);
                    int inversion = inverseRotation ? -1 : 1;
                    double targetTorque = (double)inversion * adjacentMech.getTorque() / (double)ratio;
                    double applyTorque = targetTorque * acceleration;
                    if (Math.abs(this.torque + applyTorque) < Math.abs(targetTorque)) {
                        this.torque += applyTorque;
                    } else if (Math.abs(this.torque - applyTorque) > Math.abs(targetTorque)) {
                        this.torque -= applyTorque;
                    }
                    double targetVelocity = (double)inversion * adjacentMech.getAngularVelocity() * (double)ratio;
                    double applyVelocity = targetVelocity * acceleration;
                    if (Math.abs(this.angularVelocity + applyVelocity) < Math.abs(targetVelocity)) {
                        this.angularVelocity += applyVelocity;
                        continue;
                    }
                    if (!(Math.abs(this.angularVelocity - applyVelocity) > Math.abs(targetVelocity))) continue;
                    this.angularVelocity -= applyVelocity;
                }
            }
        }
        this.onUpdate();
        this.prev_angle = this.angle;
    }

    protected void onUpdate() {
    }

    protected void revolve() {
    }

    public void apply(Object source, double torque, double angularVelocity) {
        this.torque += torque;
        this.angularVelocity += angularVelocity;
    }

    public double getTorque() {
        return this.angularVelocity != 0.0 ? this.torque : 0.0;
    }

    public double getAngularVelocity() {
        return this.torque != 0.0 ? this.angularVelocity : 0.0;
    }

    public float getRatio(ForgeDirection dir, IMechanicalNode with) {
        return 0.5f;
    }

    public boolean inverseRotation(ForgeDirection dir, IMechanicalNode with) {
        return true;
    }

    public double getTorqueLoad() {
        return this.load;
    }

    public double getAngularVelocityLoad() {
        return this.load;
    }

    public void doRecache() {
        this.connections.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            MechanicalNode check;
            TileEntity tile = this.position().translate(dir).getTileEntity((IBlockAccess)this.world());
            if (!(tile instanceof INodeProvider) || (check = (MechanicalNode)((INodeProvider)tile).getNode(MechanicalNode.class, dir.getOpposite())) == null || !this.canConnect(dir, (Object)check) || !check.canConnect(dir.getOpposite(), (Object)this)) continue;
            this.connections.put(check, dir);
        }
    }

    public World world() {
        return this.parent instanceof TMultiPart ? ((TMultiPart)this.parent).world() : (this.parent instanceof TileEntity ? ((TileEntity)this.parent).func_70314_l() : null);
    }

    public Vector3 position() {
        return this.parent instanceof TMultiPart ? new Vector3((double)((TMultiPart)this.parent).x(), (double)((TMultiPart)this.parent).y(), (double)((TMultiPart)this.parent).z()) : (this.parent instanceof TileEntity ? new Vector3((TileEntity)this.parent) : null);
    }

    public boolean canConnect(ForgeDirection from, Object source) {
        return source instanceof MechanicalNode && (this.connectionMap & 1 << from.ordinal()) != 0;
    }

    public double getEnergy() {
        return this.getTorque() * this.getAngularVelocity();
    }

    public double getPower() {
        return this.power;
    }

    public TickingGrid newGrid() {
        return new TickingGrid((Node)this, MechanicalNode.class);
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.torque = nbt.func_74769_h("torque");
        this.angularVelocity = nbt.func_74769_h("angularVelocity");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74780_a("torque", this.torque);
        nbt.func_74780_a("angularVelocity", this.angularVelocity);
    }
}

