/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.grid;

import com.google.common.io.ByteArrayDataInput;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.lib.content.module.TileBase;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonantinduction.core.ResonantInduction;
import resonantinduction.mechanical.Mechanical;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public abstract class TileMechanical
extends TileBase
implements INodeProvider,
IPacketReceiver {
    protected static final int PACKET_VELOCITY = Mechanical.contentRegistry.getNextPacketID();
    public MechanicalNode mechanicalNode = new PacketMechanicalNode(this).setLoad(0.5);
    private boolean markPacketUpdate;

    @Deprecated
    public TileMechanical() {
        super(null);
    }

    public TileMechanical(Material material) {
        super(material);
    }

    public void initiate() {
        this.mechanicalNode.reconstruct();
        super.initiate();
    }

    public void func_70313_j() {
        this.mechanicalNode.deconstruct();
        super.func_70313_j();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.markPacketUpdate && this.ticks % 10L == 0L) {
            this.sendRotationPacket();
            this.markPacketUpdate = false;
        }
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(((Object)((Object)this.mechanicalNode)).getClass())) {
            return this.mechanicalNode;
        }
        return null;
    }

    private void sendRotationPacket() {
        PacketHandler.sendPacketToClients((Packet)ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{PACKET_VELOCITY, this.mechanicalNode.angularVelocity}), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)20.0);
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        this.onReceivePacket(data.readInt(), data, player, extra);
    }

    public void onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        if (id == PACKET_VELOCITY) {
            this.mechanicalNode.angularVelocity = data.readDouble();
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.mechanicalNode.load(nbt);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.mechanicalNode.save(nbt);
    }

    protected class PacketMechanicalNode
    extends MechanicalNode {
        public PacketMechanicalNode(INodeProvider parent) {
            super(parent);
        }

        @Override
        protected void onUpdate() {
            if (Math.abs(this.prevAngularVelocity - this.angularVelocity) > 0.001 || this.prevAngularVelocity != this.angularVelocity && (this.prevAngularVelocity == 0.0 || this.angularVelocity == 0.0)) {
                this.prevAngularVelocity = this.angularVelocity;
                TileMechanical.this.markPacketUpdate = true;
            }
        }
    }
}

