/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.mechanical.energy.turbine.TileMechanicalTurbine;

@SideOnly(value=Side.CLIENT)
public class RenderWaterTurbine
extends TileEntitySpecialRenderer
implements ISimpleItemRenderer {
    public static final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/waterTurbines.obj");

    public void func_76894_a(TileEntity t, double x, double y, double z, float f) {
        TileMechanicalTurbine tile = (TileMechanicalTurbine)t;
        if (tile.getMultiBlock().isPrimary()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glPushMatrix();
            RenderUtility.rotateBlockBasedOnDirectionUp((ForgeDirection)tile.getDirection());
            GL11.glRotatef((float)((float)Math.toDegrees(tile.renderAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
            if (tile.getDirection().offsetY != 0) {
                this.renderWaterTurbine(tile.tier, tile.multiBlockRadius, tile.getMultiBlock().isConstructed());
            } else {
                this.renderWaterWheel(tile.tier, tile.multiBlockRadius, tile.getMultiBlock().isConstructed());
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderWaterTurbine(itemStack.func_77960_j(), 1, false);
        GL11.glPopMatrix();
    }

    public void renderWaterWheel(int tier, int size, boolean isLarge) {
        if (isLarge) {
            GL11.glScalef((float)0.3f, (float)1.0f, (float)0.3f);
            GL11.glScalef((float)(size * 2 + 1), (float)Math.min(size, 2), (float)(size * 2 + 1));
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0f, (float)1.6f, (float)1.0f);
            RenderUtility.bind((String)"textures/blocks/cobblestone.png");
            MODEL.renderOnly(new String[]{"bigwheel_endknot", "horizontal_centre_shaft"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0f, (float)1.4f, (float)1.0f);
            RenderUtility.bind((String)"textures/blocks/planks_spruce.png");
            MODEL.renderOnly(new String[]{"bigwheel_supporters"});
            this.bindTexture(tier);
            MODEL.renderOnly(new String[]{"bigwheel_scoops", "bigwheel_supportercircle"});
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.7f, (float)1.0f, (float)0.7f);
            RenderUtility.bind((String)"textures/blocks/cobblestone.png");
            MODEL.renderOnly(new String[]{"small_waterwheel_endknot"});
            this.bindTexture(tier);
            MODEL.renderOnly(new String[]{"small_waterwheel", "small_waterwheel_supporters", "horizontal_centre_shaft"});
            GL11.glPopMatrix();
        }
    }

    public void renderWaterTurbine(int tier, int size, boolean isLarge) {
        if (isLarge) {
            GL11.glScalef((float)0.3f, (float)1.0f, (float)0.3f);
            GL11.glScalef((float)(size * 2 + 1), (float)Math.min(size, 2), (float)(size * 2 + 1));
            this.bindTexture(tier);
            MODEL.renderOnly(new String[]{"turbine_centre"});
            MODEL.renderOnly(new String[]{"turbine_blades"});
        } else {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.9f, (float)1.0f, (float)0.9f);
            RenderUtility.bind((String)"textures/blocks/log_oak.png");
            MODEL.renderOnly(new String[]{"small_waterwheel_endknot"});
            this.bindTexture(tier);
            MODEL.renderOnly(new String[]{"small_turbine_blades"});
            GL11.glPopMatrix();
        }
    }

    public void bindTexture(int tier) {
        switch (tier) {
            case 0: {
                RenderUtility.bind((String)"textures/blocks/planks_oak.png");
                break;
            }
            case 1: {
                RenderUtility.bind((String)"textures/blocks/cobblestone.png");
                break;
            }
            case 2: {
                RenderUtility.bind((String)"textures/blocks/iron_block.png");
            }
        }
    }
}

