/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.mechanical.energy.turbine.TileMechanicalTurbine;

@SideOnly(value=Side.CLIENT)
public class RenderWindTurbine
extends TileEntitySpecialRenderer
implements ISimpleItemRenderer {
    public static final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/windTurbines.obj");

    public void func_76894_a(TileEntity t, double x, double y, double z, float f) {
        TileMechanicalTurbine tile = (TileMechanicalTurbine)t;
        if (tile.getMultiBlock().isPrimary()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glPushMatrix();
            RenderUtility.rotateBlockBasedOnDirectionUp((ForgeDirection)tile.getDirection());
            GL11.glTranslatef((float)0.0f, (float)-0.35f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(tile.renderAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
            this.render(tile.tier, tile.multiBlockRadius, tile.getMultiBlock().isConstructed());
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.render(itemStack.func_77960_j(), 1, false);
        GL11.glPopMatrix();
    }

    public void render(int tier, int size, boolean isConstructed) {
        switch (tier) {
            case 0: {
                RenderUtility.bind((String)"textures/blocks/planks_oak.png");
                break;
            }
            case 1: {
                RenderUtility.bind((String)"textures/blocks/cobblestone.png");
                break;
            }
            case 2: {
                RenderUtility.bind((String)"textures/blocks/iron_block.png");
            }
        }
        if (isConstructed) {
            GL11.glScalef((float)0.3f, (float)1.0f, (float)0.3f);
            GL11.glScalef((float)(size * 2 + 1), (float)Math.min(size, 2), (float)(size * 2 + 1));
            if (tier == 2) {
                GL11.glTranslatef((float)0.0f, (float)-0.11f, (float)0.0f);
                MODEL.renderOnly(new String[]{"LargeMetalBlade"});
                MODEL.renderOnly(new String[]{"LargeMetalHub"});
            } else {
                MODEL.renderOnly(new String[]{"LargeBladeArm"});
                GL11.glScalef((float)1.0f, (float)2.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                MODEL.renderOnly(new String[]{"LargeHub"});
                RenderUtility.bind((String)"textures/blocks/wool_colored_white.png");
                MODEL.renderOnly(new String[]{"LargeBlade"});
            }
        } else {
            MODEL.renderOnly(new String[]{"SmallBlade"});
            RenderUtility.bind((String)"textures/blocks/log_oak.png");
            MODEL.renderOnly(new String[]{"SmallHub"});
        }
    }
}

