/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.energy.turbine;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INodeProvider;
import resonantinduction.core.Settings;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.energy.turbine.TileMechanicalTurbine;
import resonantinduction.mechanical.energy.turbine.TileTurbineBase;
import universalelectricity.api.vector.Vector3;

public class TileWaterTurbine
extends TileMechanicalTurbine {
    public int powerTicks = 0;

    public TileWaterTurbine() {
        this.torque = 5000L;
        this.mechanicalNode = new TileMechanicalTurbine.TurbineNode((INodeProvider)this){

            @Override
            public boolean canConnect(ForgeDirection from, Object source) {
                TileEntity sourceTile;
                if (source instanceof MechanicalNode && !(source instanceof TileMechanicalTurbine) && (sourceTile = this.position().translate(from).getTileEntity((IBlockAccess)TileWaterTurbine.this.getWorld())) instanceof INodeProvider) {
                    MechanicalNode sourceInstance = (MechanicalNode)((INodeProvider)sourceTile).getNode(MechanicalNode.class, from.getOpposite());
                    return sourceInstance == source && (from == TileWaterTurbine.this.getDirection().getOpposite() || from == TileWaterTurbine.this.getDirection());
                }
                return false;
            }
        };
    }

    @Override
    public void func_70316_g() {
        block7: {
            block6: {
                boolean isWater;
                this.torque = this.getMultiBlock().isConstructed() ? (long)(5000.0 / (1.0 / (double)this.multiBlockRadius)) : 416L;
                if (this.getDirection().offsetY == 0) break block6;
                this.maxPower = 10000L;
                if (this.powerTicks > 0) {
                    ((TileTurbineBase)this.getMultiBlock().get()).power += this.getWaterPower();
                    --this.powerTicks;
                }
                if (this.ticks % 20L != 0L) break block7;
                int blockIDAbove = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                int metadata = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                boolean bl = isWater = blockIDAbove == Block.field_71943_B.field_71990_ca || blockIDAbove == Block.field_71942_A.field_71990_ca;
                if (!isWater || !this.field_70331_k.func_72799_c(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) || metadata != 0) break block7;
                this.powerTicks = 20;
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, Block.field_71942_A.field_71990_ca);
                break block7;
            }
            this.maxPower = 2500L;
            ForgeDirection currentDir = this.getDirection();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == currentDir || dir == currentDir.getOpposite()) continue;
                Vector3 check = new Vector3((TileEntity)this).translate(dir);
                int blockID = this.field_70331_k.func_72798_a(check.intX(), check.intY(), check.intZ());
                int metadata = this.field_70331_k.func_72805_g(check.intX(), check.intY(), check.intZ());
                if (blockID != Block.field_71942_A.field_71990_ca && blockID != Block.field_71943_B.field_71990_ca) continue;
                try {
                    Method m = ReflectionHelper.findMethod(BlockFluid.class, null, (String[])new String[]{"getFlowVector", "func_72202_i"}, (Class[])new Class[]{IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
                    Vector3 vector = new Vector3((Vec3)m.invoke((Object)Block.field_71942_A, this.field_70331_k, check.intX(), check.intY(), check.intZ()));
                    if (currentDir.offsetZ > 0 && vector.x < 0.0 || currentDir.offsetZ < 0 && vector.x > 0.0 || currentDir.offsetX > 0 && vector.z > 0.0 || currentDir.offsetX < 0 && vector.z < 0.0) {
                        this.torque = -this.torque;
                    }
                    if (this.getDirection().offsetX != 0) {
                        ((TileTurbineBase)this.getMultiBlock().get()).power = (long)((double)((TileTurbineBase)this.getMultiBlock().get()).power + Math.abs((double)this.getWaterPower() * vector.z * (double)(7 - metadata) / 7.0));
                    }
                    if (this.getDirection().offsetZ == 0) continue;
                    ((TileTurbineBase)this.getMultiBlock().get()).power = (long)((double)((TileTurbineBase)this.getMultiBlock().get()).power + Math.abs((double)this.getWaterPower() * vector.x * (double)(7 - metadata) / 7.0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.func_70316_g();
    }

    private long getWaterPower() {
        return this.maxPower / (long)(2 - this.tier + 1) * (long)Settings.WATER_POWER_RATIO;
    }
}

