/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.fluid.pipe;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.lib.type.EvictingList;
import resonant.lib.utility.WorldUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.core.prefab.part.PartFramedNode;
import resonantinduction.mechanical.Mechanical;
import resonantinduction.mechanical.fluid.pipe.EnumPipeMaterial;
import resonantinduction.mechanical.fluid.pipe.RenderPipe;

public class PartPipe
extends PartFramedNode<EnumPipeMaterial, FluidPressureNode, IPressureNodeProvider>
implements IPressureNodeProvider,
TSlottedPart,
JNormalOcclusion,
IHollowConnect {
    protected final FluidTank tank = new FluidTank(1000);
    private EvictingList<Integer> averageTankData = new EvictingList(20);
    private boolean markPacket = true;

    public PartPipe() {
        super(null);
        this.material = EnumPipeMaterial.values()[0];
        this.requiresInsulation = false;
        this.node = new FluidPressureNode(this){

            public void doRecache() {
                this.connections.clear();
                if (this.world() != null) {
                    byte previousConnections = PartPipe.this.getAllCurrentConnections();
                    PartPipe.this.currentConnections = 0;
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        TileEntity tile = this.position().translate(dir).getTileEntity((IBlockAccess)this.world());
                        if (!(tile instanceof IFluidHandler)) continue;
                        if (tile instanceof IPressureNodeProvider) {
                            FluidPressureNode check = (FluidPressureNode)((IPressureNodeProvider)tile).getNode(FluidPressureNode.class, dir.getOpposite());
                            if (check == null || !this.canConnect(dir, check) || !check.canConnect(dir.getOpposite(), (Object)this)) continue;
                            PartPipe.this.currentConnections = WorldUtility.setEnableSide((byte)PartPipe.this.currentConnections, (ForgeDirection)dir, (boolean)true);
                            this.connections.put(check, dir);
                            continue;
                        }
                        if (!this.canConnect(dir, tile)) continue;
                        PartPipe.this.currentConnections = WorldUtility.setEnableSide((byte)PartPipe.this.currentConnections, (ForgeDirection)dir, (boolean)true);
                        this.connections.put(tile, dir);
                    }
                    if (!this.world().field_72995_K && previousConnections != PartPipe.this.currentConnections) {
                        PartPipe.this.sendConnectionUpdate();
                    }
                }
            }

            public boolean canConnect(ForgeDirection from, Object source) {
                if (!PartPipe.this.isBlockedOnSide(from)) {
                    if (source instanceof FluidPressureNode) {
                        FluidPressureNode otherNode = (FluidPressureNode)source;
                        if (otherNode.parent instanceof PartPipe) {
                            PartPipe otherPipe = (PartPipe)otherNode.parent;
                            if (!otherPipe.isBlockedOnSide(from.getOpposite()) && PartPipe.this.getMaterial() == otherPipe.getMaterial()) {
                                return PartPipe.this.getColor() == otherPipe.getColor() || PartPipe.this.getColor() == 15 || otherPipe.getColor() == 15;
                            }
                            return false;
                        }
                    }
                    return super.canConnect(from, source) || source instanceof IFluidHandler;
                }
                return false;
            }
        };
    }

    public void setMaterial(int i) {
        this.setMaterial(EnumPipeMaterial.values()[i]);
    }

    public void setMaterial(EnumPipeMaterial material) {
        this.material = material;
        ((FluidPressureNode)this.node).maxFlowRate = ((EnumPipeMaterial)this.getMaterial()).maxFlowRate;
        ((FluidPressureNode)this.node).maxPressure = ((EnumPipeMaterial)this.getMaterial()).maxPressure;
        this.tank.setCapacity(((FluidPressureNode)this.node).maxFlowRate);
    }

    public String getType() {
        return "resonant_induction_pipe";
    }

    public void update() {
        super.update();
        this.averageTankData.add((Object)this.tank.getFluidAmount());
        if (!this.world().field_72995_K && this.markPacket) {
            this.sendFluidUpdate();
            this.markPacket = false;
        }
    }

    public void sendFluidUpdate() {
        NBTTagCompound nbt = new NBTTagCompound();
        int averageAmount = 0;
        if (this.averageTankData.size() > 0) {
            for (int i = 0; i < this.averageTankData.size(); ++i) {
                averageAmount += ((Integer)this.averageTankData.get(i)).intValue();
            }
            averageAmount /= this.averageTankData.size();
        }
        FluidTank tempTank = this.tank.getFluid() != null ? new FluidTank(this.tank.getFluid().getFluid(), averageAmount, this.tank.getCapacity()) : new FluidTank(this.tank.getCapacity());
        tempTank.writeToNBT(nbt);
        this.tile().getWriteStream((TMultiPart)this).writeByte(3).writeInt(this.tank.getCapacity()).writeNBTTagCompound(nbt);
    }

    public void read(MCDataInput packet, int packetID) {
        if (packetID == 3) {
            this.tank.setCapacity(packet.readInt());
            this.tank.readFromNBT(packet.readNBTTagCompound());
        } else {
            super.read(packet, packetID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        RenderPipe.INSTANCE.render(this, pos.x, pos.y, pos.z, frame);
    }

    protected ItemStack getItem() {
        return new ItemStack(Mechanical.itemPipe, 1, this.getMaterialID());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.world().field_72995_K) {
            if (doFill) {
                this.markPacket = true;
            }
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.world().field_72995_K) {
            if (doDrain) {
                this.markPacket = true;
            }
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidTank getPressureTank() {
        return this.tank;
    }

    public void drawBreaking(RenderBlocks renderBlocks) {
        CCRenderState.reset();
        RenderUtils.renderBlock((Cuboid6)sides[6], (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(ResonantInduction.blockIndustrialStone.func_71858_a(0, 0)), null);
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        this.tank.writeToNBT(nbt);
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.tank.readFromNBT(nbt);
        ((FluidPressureNode)this.node).maxFlowRate = ((EnumPipeMaterial)this.getMaterial()).maxFlowRate;
        ((FluidPressureNode)this.node).maxPressure = ((EnumPipeMaterial)this.getMaterial()).maxPressure;
    }

    public void onFluidChanged() {
    }
}

