/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.fluid.pipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.FluidRenderUtility;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.WorldUtility;
import resonantinduction.mechanical.fluid.pipe.EnumPipeMaterial;
import resonantinduction.mechanical.fluid.pipe.PartPipe;

@SideOnly(value=Side.CLIENT)
public class RenderPipe
implements ISimpleItemRenderer {
    public static final RenderPipe INSTANCE = new RenderPipe();
    public static final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/pipe.tcn");
    public static ResourceLocation TEXTURE = new ResourceLocation("resonantinduction", "models/pipe.png");

    public void render(PartPipe part, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderPipe.render(part.getMaterialID(), part.getColor() > 0 ? ItemDye.field_77859_b[part.getColor()] : -1, part.getAllCurrentConnections());
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        FluidStack fluid = part.getPressureTank().getFluid();
        int capacity = part.getPressureTank().getCapacity();
        byte renderSides = part.getAllCurrentConnections();
        if (fluid != null && fluid.amount > 0) {
            double filledPercentage = Math.min((double)fluid.amount / (double)capacity, 1.0);
            double renderPercentage = fluid.getFluid().isGaseous() ? 1.0 : filledPercentage;
            int[] displayList = FluidRenderUtility.getFluidDisplayLists((FluidStack)fluid, (World)part.world(), (boolean)false);
            RenderUtility.bind((ResourceLocation)FluidRenderUtility.getFluidSheet((FluidStack)fluid));
            Color color = new Color(fluid.getFluid().getColor());
            GL11.glColor4d((double)(color.getRed() / 255), (double)(color.getGreen() / 255), (double)(color.getBlue() / 255), (double)(fluid.getFluid().isGaseous() ? filledPercentage : 1.0));
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)((float)x + 0.35f), (float)((float)y + 0.35f), (float)((float)z + 0.35f));
            GL11.glScalef((float)0.33f, (float)0.33f, (float)0.33f);
            GL11.glCallList((int)displayList[(int)(renderPercentage * 99.0)]);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (!WorldUtility.isEnabledSide((byte)renderSides, (ForgeDirection)direction)) continue;
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)8192);
                GL11.glEnable((int)2884);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                switch (direction.ordinal()) {
                    case 0: {
                        GL11.glTranslatef((float)((float)x + 0.35f), (float)((float)y - 0.0f), (float)((float)z + 0.35f));
                        break;
                    }
                    case 1: {
                        GL11.glTranslatef((float)((float)x + 0.35f), (float)((float)y + 0.65f), (float)((float)z + 0.35f));
                        break;
                    }
                    case 2: {
                        GL11.glTranslatef((float)((float)x + 0.35f), (float)((float)y + 0.35f), (float)((float)z + 0.0f));
                        break;
                    }
                    case 3: {
                        GL11.glTranslatef((float)((float)x + 0.35f), (float)((float)y + 0.35f), (float)((float)z + 0.65f));
                        break;
                    }
                    case 4: {
                        GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.35f), (float)((float)z + 0.35f));
                        break;
                    }
                    case 5: {
                        GL11.glTranslatef((float)((float)x + 0.65f), (float)((float)y + 0.35f), (float)((float)z + 0.35f));
                    }
                }
                GL11.glScalef((float)0.33f, (float)0.33f, (float)0.33f);
                GL11.glCallList((int)displayList[(int)(renderPercentage * 99.0)]);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    public static void render(int meta, int colorCode, byte sides) {
        RenderUtility.enableBlending();
        RenderUtility.bind((ResourceLocation)TEXTURE);
        EnumPipeMaterial material = EnumPipeMaterial.values()[meta];
        GL11.glColor4f((float)((float)material.color.getRed() / 255.0f), (float)((float)material.color.getGreen() / 255.0f), (float)((float)material.color.getBlue() / 255.0f), (float)1.0f);
        MODEL.renderOnly(new String[]{"Mid"});
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)dir)) continue;
            GL11.glColor4f((float)((float)material.color.getRed() / 255.0f), (float)((float)material.color.getGreen() / 255.0f), (float)((float)material.color.getBlue() / 255.0f), (float)1.0f);
            String prefix = null;
            switch (dir) {
                case DOWN: {
                    prefix = "Bottom";
                    break;
                }
                case UP: {
                    prefix = "Top";
                    break;
                }
                case NORTH: {
                    prefix = "Front";
                    break;
                }
                case SOUTH: {
                    prefix = "Back";
                    break;
                }
                case WEST: {
                    prefix = "Right";
                    break;
                }
                case EAST: {
                    prefix = "Left";
                }
            }
            MODEL.renderOnly(new String[]{prefix + "Inter", prefix + "Connect"});
            if (colorCode > 0) {
                Color color = new Color(colorCode);
                GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            }
            MODEL.renderOnly(new String[]{prefix + "Pipe"});
        }
        RenderUtility.disableBlending();
    }

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        RenderPipe.render(itemStack.func_77960_j(), -1, Byte.parseByte("001100", 2));
        GL11.glPopMatrix();
    }
}

