/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.fluid.transport;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IRotatable;
import resonant.api.grid.INode;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.mechanical.energy.grid.TileMechanical;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.Vector3;

public class TilePump
extends TileMechanical
implements IPressureNodeProvider,
IRotatable {
    private final FluidPressureNode pressureNode = new FluidPressureNode(this){

        public int getPressure(ForgeDirection dir) {
            if (TilePump.this.mechanicalNode.getPower() > 0.0) {
                if (dir == TilePump.this.getDirection()) {
                    return (int)Math.max(Math.abs(TilePump.this.mechanicalNode.getTorque() / 8000.0), 2.0);
                }
                if (dir == TilePump.this.getDirection().getOpposite()) {
                    return (int)(-Math.max(Math.abs(TilePump.this.mechanicalNode.getTorque() / 8000.0), 2.0));
                }
            }
            return 0;
        }

        public int getMaxFlowRate() {
            return (int)Math.abs(TilePump.this.mechanicalNode.getAngularVelocity() * 1000.0);
        }

        public boolean canConnect(ForgeDirection from, Object source) {
            return super.canConnect(from, source) && (from == TilePump.this.getDirection() || from == TilePump.this.getDirection().getOpposite());
        }
    };

    public TilePump() {
        super(UniversalElectricity.machine);
        this.normalRender = false;
        this.isOpaqueCube = false;
        this.customItemRender = true;
        this.rotationMask = Byte.parseByte("111111", 2);
        this.textureName = "material_steel";
    }

    @Override
    public void initiate() {
        this.pressureNode.reconstruct();
        super.initiate();
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.pressureNode.deconstruct();
    }

    @Override
    public void func_70316_g() {
        FluidStack drain;
        TileEntity tileIn;
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.mechanicalNode.getPower() > 0.0 && (tileIn = new Vector3((TileEntity)this).translate(this.getDirection().getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IFluidHandler && (drain = ((IFluidHandler)tileIn).drain(this.getDirection(), this.pressureNode.getMaxFlowRate(), false)) != null) {
            ((IFluidHandler)tileIn).drain(this.getDirection(), this.fill(this.getDirection().getOpposite(), drain, true), true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TileEntity tileOut;
        if (from == this.getDirection().getOpposite() && (tileOut = new Vector3((TileEntity)this).translate(from.getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IFluidHandler) {
            return ((IFluidHandler)tileOut).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == this.getDirection().getOpposite();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == this.getDirection();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public FluidTank getPressureTank() {
        return new FluidTank(0);
    }

    @Override
    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(this.pressureNode.getClass())) {
            return this.pressureNode;
        }
        return super.getNode(nodeType, from);
    }

    public void onFluidChanged() {
    }
}

