/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gear;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.microblock.FaceMicroClass;
import codechicken.multipart.ControlKeyModifer;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INode;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.multiblock.MultiBlockHandler;
import resonant.lib.utility.WrenchUtility;
import resonantinduction.core.resource.ItemHandCrank;
import resonantinduction.mechanical.Mechanical;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.energy.grid.PartMechanical;
import resonantinduction.mechanical.gear.GearMultiBlockHandler;
import resonantinduction.mechanical.gear.RenderGear;
import universalelectricity.api.vector.Vector3;

public class PartGear
extends PartMechanical
implements IMultiBlockStructure<PartGear> {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    private boolean isClockwiseCrank = true;
    private int manualCrankTime = 0;
    private int multiBlockRadius = 1;
    private GearMultiBlockHandler multiBlock;

    public PartGear() {
        this.node = new MechanicalNode(this);
    }

    @Override
    public void update() {
        super.update();
        if (!this.world().field_72995_K && this.manualCrankTime > 0) {
            this.node.apply((Object)this, this.isClockwiseCrank ? 15.0 : -15.0, this.isClockwiseCrank ? (double)0.025f : (double)-0.025f);
            --this.manualCrankTime;
        }
        this.getMultiBlock().update();
    }

    @Override
    public void checkClientUpdate() {
        if (this.getMultiBlock().isPrimary()) {
            super.checkClientUpdate();
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemHandCrank) {
            if (!this.world().field_72995_K && ControlKeyModifer.isControlDown((EntityPlayer)player)) {
                ((PartGear)this.getMultiBlock().get()).node.torque = -((PartGear)this.getMultiBlock().get()).node.torque;
                ((PartGear)this.getMultiBlock().get()).node.angularVelocity = -((PartGear)this.getMultiBlock().get()).node.angularVelocity;
                return true;
            }
            this.isClockwiseCrank = player.func_70093_af();
            ((PartGear)this.getMultiBlock().get()).manualCrankTime = 20;
            this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "resonantinduction:gearCrank", 0.5f, 0.9f + this.world().field_73012_v.nextFloat() * 0.2f);
            player.func_71020_j(0.01f);
            return true;
        }
        if (WrenchUtility.isWrench((ItemStack)itemStack)) {
            this.getMultiBlock().toggleConstruct();
            return true;
        }
        return super.activate(player, hit, itemStack);
    }

    public void preRemove() {
        super.preRemove();
        this.getMultiBlock().deconstruct();
    }

    public boolean isCenterMultiBlock() {
        if (!this.getMultiBlock().isConstructed()) {
            return true;
        }
        Vector3 primaryPos = ((PartGear)this.getMultiBlock().getPrimary()).getPosition();
        if (primaryPos.intX() == this.x() && this.placementSide.offsetX == 0) {
            return true;
        }
        if (primaryPos.intY() == this.y() && this.placementSide.offsetY == 0) {
            return true;
        }
        return primaryPos.intZ() == this.z() && this.placementSide.offsetZ == 0;
    }

    @Override
    protected ItemStack getItem() {
        return new ItemStack(Mechanical.itemGear, 1, this.tier);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderGear.INSTANCE.renderDynamic(this, pos.x, pos.y, pos.z, this.tier);
        }
    }

    public String getType() {
        return "resonant_induction_gear";
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.getMultiBlock().load(nbt);
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        this.getMultiBlock().save(nbt);
    }

    public Vector3[] getMultiBlockVectors() {
        HashSet<Vector3> vectors = new HashSet<Vector3>();
        ForgeDirection dir = this.placementSide;
        Vector3 rotationalAxis = Vector3.UP();
        if (this.placementSide == ForgeDirection.NORTH || this.placementSide == ForgeDirection.SOUTH) {
            rotationalAxis = Vector3.EAST();
        } else if (this.placementSide == ForgeDirection.WEST || this.placementSide == ForgeDirection.EAST) {
            rotationalAxis = Vector3.SOUTH();
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Vector3 vector = new Vector3((double)x, 0.0, (double)z);
                vector.rotate(90.0f, rotationalAxis);
                vector = vector.round();
                vectors.add(vector);
            }
        }
        return vectors.toArray(new Vector3[0]);
    }

    public World getWorld() {
        return this.world();
    }

    public void onMultiBlockChanged() {
        if (this.world() != null) {
            this.tile().notifyPartChange((TMultiPart)this);
            if (!this.world().field_72995_K) {
                this.sendDescUpdate();
            }
        }
    }

    public MultiBlockHandler<PartGear> getMultiBlock() {
        if (this.multiBlock == null) {
            this.multiBlock = new GearMultiBlockHandler(this);
        }
        return this.multiBlock;
    }

    @Override
    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(((Object)((Object)this.node)).getClass())) {
            return ((PartGear)this.getMultiBlock().get()).node;
        }
        return null;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(oBoxes[this.placementSide.ordinal()]);
    }

    public int getSlotMask() {
        return 1 << this.placementSide.ordinal();
    }

    public Cuboid6 getBounds() {
        return FaceMicroClass.aBounds()[0x10 | this.placementSide.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public Cuboid6 getRenderBounds() {
        return Cuboid6.full.copy().expand((double)this.multiBlockRadius);
    }

    public String toString() {
        return "[PartGear]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }

    static {
        PartGear.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.125, 1.0);
        PartGear.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.125, 0.875);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(codechicken.lib.vec.Vector3.center);
            PartGear.oBoxes[s][0] = oBoxes[0][0].copy().apply(t);
            PartGear.oBoxes[s][1] = oBoxes[0][1].copy().apply(t);
        }
    }
}

