/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gear;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.mechanical.gear.PartGear;

@SideOnly(value=Side.CLIENT)
public class RenderGear
implements ISimpleItemRenderer {
    public static final RenderGear INSTANCE = new RenderGear();
    public final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/gears.obj");

    public void renderGear(int side, int tier, boolean isLarge, double angle) {
        switch (tier) {
            default: {
                RenderUtility.bind((String)"textures/blocks/planks_oak.png");
                break;
            }
            case 1: {
                RenderUtility.bind((String)"textures/blocks/cobblestone.png");
                break;
            }
            case 2: {
                RenderUtility.bind((String)"textures/blocks/iron_block.png");
                break;
            }
            case 10: {
                RenderUtility.bind((String)"textures/blocks/pumpkin_top.png");
            }
        }
        RenderUtility.rotateFaceBlockToSide((ForgeDirection)ForgeDirection.getOrientation((int)side));
        GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        if (isLarge) {
            this.MODEL.renderOnly(new String[]{"LargeGear"});
        } else {
            this.MODEL.renderOnly(new String[]{"SmallGear"});
        }
    }

    public void renderDynamic(PartGear part, double x, double y, double z, int tier) {
        if (part.getMultiBlock().isPrimary()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glPushMatrix();
            this.renderGear(part.placementSide.ordinal(), part.tier, part.getMultiBlock().isConstructed(), Math.toDegrees(part.node.angle));
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderGear(-1, itemStack.func_77960_j(), false, 0.0);
    }
}

