/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gear.dev;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraftforge.common.ForgeDirection;
import resonantinduction.mechanical.gear.dev.NodeGear;
import resonantinduction.mechanical.gear.dev.NodeGenerator;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.IUpdate;
import universalelectricity.core.net.ConnectionPathfinder;

public class GearNetwork
implements IUpdate {
    private final Set<NodeGear> nodes = Collections.newSetFromMap(new WeakHashMap());
    private final Set<NodeGenerator> generators = Collections.newSetFromMap(new WeakHashMap());
    private boolean doRemap = true;
    private boolean isDead = false;

    public GearNetwork() {
    }

    public GearNetwork(NodeGear nodeGear) {
        this();
        this.onAdded(nodeGear);
    }

    public void onAdded(NodeGear gear) {
        this.onAdded(gear, true);
    }

    public void onAdded(NodeGear gear, boolean checkMerge) {
        if (gear instanceof NodeGenerator) {
            if (!this.generators.contains(gear)) {
                this.generators.add((NodeGenerator)gear);
                if (checkMerge) {
                    this.checkForMerge(gear);
                }
                this.doRemap = true;
            }
        } else if (!this.nodes.contains(gear)) {
            this.nodes.add(gear);
            if (checkMerge) {
                this.checkForMerge(gear);
            }
            this.doRemap = true;
        }
    }

    public void checkForMerge(NodeGear gear) {
    }

    public void onRemoved(NodeGear gear, boolean doSplit) {
        if (this.generators.remove(gear) || this.nodes.remove(gear)) {
            if (doSplit) {
                this.split(gear);
            }
            this.doRemap = true;
        }
    }

    public void update() {
        if (this.doRemap) {
            this.doRemap = false;
        }
    }

    public boolean canUpdate() {
        return !this.isDead;
    }

    public boolean continueUpdate() {
        return this.canUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GearNetwork merge(GearNetwork network) {
        if (network != null && network.getClass().isAssignableFrom(this.getClass()) && network != this) {
            GearNetwork gearNetwork = this;
            synchronized (gearNetwork) {
                GearNetwork newNetwork = new GearNetwork();
                newNetwork.nodes.addAll(this.nodes);
                newNetwork.nodes.addAll(network.nodes);
                newNetwork.generators.addAll(this.generators);
                newNetwork.generators.addAll(network.generators);
                network.deconstruct();
                this.deconstruct();
                newNetwork.doRemap = true;
                return newNetwork;
            }
        }
        return null;
    }

    protected void split(NodeGear splitPoint) {
        WeakHashMap<NodeGear, ForgeDirection> connectedBlocks = splitPoint.connections;
        for (Map.Entry<NodeGear, ForgeDirection> entry : connectedBlocks.entrySet()) {
            NodeGear connectedA = entry.getKey();
            if (connectedA == null) continue;
            for (Map.Entry<NodeGear, ForgeDirection> entry2 : connectedBlocks.entrySet()) {
                NodeGear connectedB = entry2.getKey();
                if (connectedB == null || connectedA == connectedB) continue;
                ConnectionPathfinder finder = new ConnectionPathfinder(NodeGear.class, (IConnector)connectedB, (IConnector[])new NodeGear[]{splitPoint});
                finder.findNodes((IConnector)connectedA);
                if (finder.results.size() > 0) continue;
                try {
                    GearNetwork newNetwork = new GearNetwork();
                    for (NodeGear node : finder.closedSet) {
                        if (node == splitPoint) continue;
                        newNetwork.onAdded(node, false);
                        this.onRemoved(node, false);
                    }
                    newNetwork.reconstruct();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.reconstruct();
    }

    protected void reconstruct() {
    }

    protected void deconstruct() {
        this.nodes.clear();
        this.generators.clear();
        this.isDead = true;
    }
}

