/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gearshaft;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INodeProvider;
import resonantinduction.mechanical.energy.grid.MechanicalNode;
import resonantinduction.mechanical.gear.PartGear;
import resonantinduction.mechanical.gear.PartGearShaft;
import universalelectricity.api.vector.Vector3;

public class GearShaftNode
extends MechanicalNode {
    public GearShaftNode(PartGearShaft parent) {
        super(parent);
    }

    @Override
    public double getTorqueLoad() {
        switch (this.shaft().tier) {
            default: {
                return 0.03;
            }
            case 1: {
                return 0.02;
            }
            case 2: 
        }
        return 0.01;
    }

    @Override
    public double getAngularVelocityLoad() {
        return 0.0;
    }

    @Override
    public void doRecache() {
        this.connections.clear();
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        dirs.add(this.shaft().placementSide);
        dirs.add(this.shaft().placementSide.getOpposite());
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            MechanicalNode instance;
            ForgeDirection checkDir = (ForgeDirection)it.next();
            if (checkDir != this.shaft().placementSide && checkDir != this.shaft().placementSide.getOpposite() || !(this.shaft().tile() instanceof INodeProvider) || (instance = (MechanicalNode)((INodeProvider)this.shaft().tile()).getNode(MechanicalNode.class, checkDir)) == null || instance == this || !instance.canConnect(checkDir.getOpposite(), (Object)this)) continue;
            this.connections.put(instance, checkDir);
            it.remove();
        }
        if (!dirs.isEmpty()) {
            for (ForgeDirection checkDir : dirs) {
                MechanicalNode instance;
                TileEntity checkTile;
                if (this.connections.containsValue(checkDir) || checkDir != this.shaft().placementSide && checkDir != this.shaft().placementSide.getOpposite() || !((checkTile = new Vector3((TileEntity)this.shaft().tile()).translate(checkDir).getTileEntity((IBlockAccess)this.world())) instanceof INodeProvider) || (instance = (MechanicalNode)((INodeProvider)checkTile).getNode(MechanicalNode.class, checkDir.getOpposite())) == null || instance == this || !(instance.parent instanceof PartGearShaft) || !instance.canConnect(checkDir.getOpposite(), (Object)this)) continue;
                this.connections.put(instance, checkDir);
            }
        }
    }

    @Override
    public boolean canConnect(ForgeDirection from, Object source) {
        if (source instanceof MechanicalNode && ((MechanicalNode)((Object)source)).parent instanceof PartGear) {
            PartGear gear = (PartGear)((MechanicalNode)((Object)source)).parent;
            if (Math.abs(gear.placementSide.offsetX) != Math.abs(this.shaft().placementSide.offsetX) || Math.abs(gear.placementSide.offsetY) != Math.abs(this.shaft().placementSide.offsetY) || Math.abs(gear.placementSide.offsetZ) != Math.abs(this.shaft().placementSide.offsetZ)) {
                return false;
            }
        }
        return from == this.shaft().placementSide || from == this.shaft().placementSide.getOpposite();
    }

    @Override
    public boolean inverseRotation(ForgeDirection dir, IMechanicalNode with) {
        if (this.shaft().placementSide.offsetY != 0 || this.shaft().placementSide.offsetZ != 0) {
            return dir == this.shaft().placementSide.getOpposite();
        }
        return dir == this.shaft().placementSide;
    }

    public PartGearShaft shaft() {
        return (PartGearShaft)this.parent;
    }
}

