/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.gearshaft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.RenderUtility;
import resonantinduction.mechanical.gear.PartGearShaft;

@SideOnly(value=Side.CLIENT)
public class RenderGearShaft
implements ISimpleItemRenderer {
    public static final RenderGearShaft INSTANCE = new RenderGearShaft();
    public final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/gears.obj");

    public void renderInventoryItem(ItemStack itemStack) {
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        switch (itemStack.func_77960_j()) {
            default: {
                RenderUtility.bind((String)"textures/blocks/planks_oak.png");
                break;
            }
            case 1: {
                RenderUtility.bind((String)"textures/blocks/cobblestone.png");
                break;
            }
            case 2: {
                RenderUtility.bind((String)"textures/blocks/iron_block.png");
            }
        }
        this.MODEL.renderOnly(new String[]{"Shaft"});
    }

    public void renderDynamic(PartGearShaft part, double x, double y, double z, float frame) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glPushMatrix();
        ForgeDirection dir = part.placementSide;
        switch (dir) {
            default: {
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GL11.glRotatef((float)((float)Math.toDegrees(part.node.angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        switch (part.tier) {
            default: {
                RenderUtility.bind((String)"textures/blocks/planks_oak.png");
                break;
            }
            case 1: {
                RenderUtility.bind((String)"textures/blocks/cobblestone.png");
                break;
            }
            case 2: {
                RenderUtility.bind((String)"textures/blocks/iron_block.png");
            }
        }
        this.MODEL.renderOnly(new String[]{"Shaft"});
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

