/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.logistic.belt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import resonant.lib.content.module.TileRender;
import resonant.lib.content.module.prefab.TileInventory;
import resonant.lib.network.Synced;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.prefab.imprint.ItemImprint;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.Vector3;

public class TileSorter
extends TileInventory {
    private boolean isInverted = false;

    public TileSorter() {
        super(UniversalElectricity.machine);
        this.textureName = "material_metal_side";
        this.maxSlots = 12;
        this.normalRender = false;
        this.isOpaqueCube = false;
        this.bounds = Cuboid.full().expand(-0.01);
    }

    public boolean use(EntityPlayer player, int side, Vector3 vector3) {
        return this.interactCurrentItem(side, player);
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 vector3) {
        boolean bl = this.isInverted = !this.isInverted;
        if (this.world().field_72995_K) {
            player.func_71035_c("Sorter filter inversion: " + !this.isInverted);
        }
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 6) {
            return stack.func_77973_b() instanceof ItemImprint;
        }
        return true;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return true;
    }

    public void collide(Entity entity) {
        if (!this.world().field_72995_K && entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            this.sortItem(entityItem.func_92059_d());
            entityItem.func_70106_y();
        }
    }

    public ItemStack func_70301_a(int i) {
        if (i < 6) {
            return this.getInventory().func_70301_a(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        if (i >= 6) {
            if (itemStack != null) {
                this.sortItem(itemStack);
            }
            return;
        }
        super.func_70299_a(i, itemStack);
    }

    public void sortItem(ItemStack sortStack) {
        int size;
        Block block;
        int blockID;
        ForgeDirection dir;
        ArrayList<ForgeDirection> possibleDirections = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 6; ++i) {
            ItemStack stack;
            if (!this.isInverted != ItemImprint.isFiltering((ItemStack)(stack = this.func_70301_a(i)), (ItemStack)sortStack)) continue;
            dir = ForgeDirection.getOrientation((int)i);
            blockID = this.position().translate(dir).getBlockID((IBlockAccess)this.world());
            block = Block.field_71973_m[blockID];
            if (block != null && Block.func_71932_i((int)blockID)) continue;
            possibleDirections.add(dir);
        }
        if (possibleDirections.size() == 0) {
            ArrayList<ForgeDirection> inventoryDirections = new ArrayList<ForgeDirection>();
            for (int i = 0; i < 6; ++i) {
                dir = ForgeDirection.getOrientation((int)i);
                blockID = this.position().translate(dir).getBlockID((IBlockAccess)this.world());
                block = Block.field_71973_m[blockID];
                if (block == null || !Block.func_71932_i((int)blockID)) {
                    possibleDirections.add(dir);
                }
                if (!(this.position().translate(dir).getTileEntity((IBlockAccess)this.world()) instanceof IInventory)) continue;
                inventoryDirections.add(dir);
            }
            if (inventoryDirections.size() > 0) {
                possibleDirections = inventoryDirections;
            }
        }
        ForgeDirection dir2 = (ForgeDirection)possibleDirections.get((size = possibleDirections.size()) > 1 ? this.world().field_73012_v.nextInt(size - 1) : 0);
        Vector3 spawn = this.center().translate(dir2, 1.0);
        TileEntity tile = spawn.getTileEntity((IBlockAccess)this.world());
        ItemStack remain = sortStack;
        if (tile instanceof IInventory) {
            remain = InventoryUtility.putStackInInventory((IInventory)((IInventory)tile), (ItemStack)remain, (int)dir2.ordinal(), (boolean)false);
        }
        if (remain != null) {
            if (!this.world().field_72995_K) {
                InventoryUtility.dropItemStack((World)this.world(), (Vector3)spawn, (ItemStack)remain, (int)20, (float)0.0f);
            }
            remain = null;
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{side + 6};
    }

    public Cuboid getSelectBounds() {
        return Cuboid.full();
    }

    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        nbt.func_74767_n("isInverted");
    }

    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isInverted", this.isInverted);
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new TileRender(){
            final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/sorter.tcn");
            final ResourceLocation TEXTURE = new ResourceLocation("resonantinduction", "models/sorter.png");

            public boolean renderStatic(RenderBlocks renderer, Vector3 position) {
                return true;
            }

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                GL11.glPushMatrix();
                RenderUtility.enableBlending();
                GL11.glTranslated((double)(position.x + 0.5), (double)(position.y + 0.5), (double)(position.z + 0.5));
                RenderUtility.bind((ResourceLocation)this.TEXTURE);
                if (!isItem) {
                    for (int i = 0; i < TileSorter.this.func_70302_i_(); ++i) {
                        if (TileSorter.this.func_70301_a(i) == null) continue;
                        ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                        GL11.glPushMatrix();
                        if (dir.ordinal() == 0) {
                            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        if (dir.ordinal() == 1) {
                            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)dir);
                        if (TileSorter.this.isInverted) {
                            this.MODEL.renderOnly(new String[]{"portRed", "connector"});
                        } else {
                            this.MODEL.renderOnly(new String[]{"portBlue", "connector"});
                        }
                        GL11.glPopMatrix();
                    }
                }
                this.MODEL.renderAllExcept(new String[]{"portBlue", "portRed", "connector"});
                RenderUtility.disableBlending();
                GL11.glPopMatrix();
                return true;
            }
        };
    }
}

