/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.crusher;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.RenderUtility;
import resonantinduction.mechanical.process.crusher.TileMechanicalPiston;

@SideOnly(value=Side.CLIENT)
public class RenderMechanicalPiston
extends TileEntitySpecialRenderer {
    public static final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/piston/mechanicalPiston.tcn");
    public static ResourceLocation TEXTURE = new ResourceLocation("resonantinduction", "models/piston/mechanicalPiston_iron.png");

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        TileMechanicalPiston tile = (TileMechanicalPiston)tileEntity;
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        if (tile.field_70331_k != null) {
            RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)tile.getDirection());
        }
        RenderUtility.bind((ResourceLocation)TEXTURE);
        double angle = tile.mechanicalNode.angle;
        Object[] staticParts = new String[]{"baseRing", "leg1", "leg2", "leg3", "leg4", "connector", "basePlate", "basePlateTop", "connectorBar", "centerPiston"};
        Object[] shaftParts = new String[]{"topPlate", "outerPiston"};
        GL11.glPushMatrix();
        GL11.glRotated((double)(-Math.toDegrees(angle)), (double)0.0, (double)0.0, (double)1.0);
        MODEL.renderAllExcept((String[])ArrayUtils.addAll((Object[])shaftParts, (Object[])staticParts));
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (tile.field_70331_k != null) {
            ForgeDirection dir = tile.getDirection();
            if (tile.world().func_72799_c(tile.x() + dir.offsetX, tile.y() + dir.offsetY, tile.z() + dir.offsetZ)) {
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.4 * Math.sin(angle) - 0.5));
            } else {
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.06 * Math.sin(angle) - 0.03));
            }
        }
        MODEL.renderOnly((String[])shaftParts);
        GL11.glPopMatrix();
        MODEL.renderOnly((String[])staticParts);
        GL11.glPopMatrix();
    }
}

