/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.edit;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRotatable;
import resonant.lib.content.module.TileBase;
import resonant.lib.content.module.TileBlock;
import resonant.lib.content.module.TileRender;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.render.RotatedTextureRenderer;
import resonant.lib.utility.inventory.InternalInventoryHandler;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class TileBreaker
extends TileBase
implements IRotatable,
IPacketReceiver {
    @SideOnly(value=Side.CLIENT)
    private static Icon iconFront;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconBack;
    private boolean doWork = false;
    private InternalInventoryHandler invHandler;
    private byte place_delay = 0;

    public TileBreaker() {
        super(Material.field_76243_f);
        this.normalRender = false;
        this.rotationMask = Byte.parseByte("111111", 2);
    }

    public InternalInventoryHandler getInvHandler() {
        if (this.invHandler == null) {
            this.invHandler = new InternalInventoryHandler((TileEntity)this);
        }
        return this.invHandler;
    }

    public void onAdded() {
        this.work();
    }

    public void onNeighborChanged() {
        this.work();
    }

    public void func_70316_g() {
        if (this.doWork) {
            if (this.place_delay < 127) {
                this.place_delay = (byte)(this.place_delay + 1);
            }
            if (this.place_delay >= 10) {
                this.doWork();
                this.doWork = false;
                this.place_delay = 0;
            }
        }
    }

    public void work() {
        if (this.isIndirectlyPowered()) {
            this.doWork = true;
            this.place_delay = 0;
        }
    }

    public void doWork() {
        if (this.isIndirectlyPowered()) {
            ForgeDirection dir = this.getDirection();
            Vector3 check = this.position().translate(dir);
            VectorWorld put = (VectorWorld)this.position().translate(dir.getOpposite());
            Block block = Block.field_71973_m[check.getBlockID((IBlockAccess)this.world())];
            if (block != null) {
                int candidateMeta = this.world().func_72805_g(check.intX(), check.intY(), check.intZ());
                boolean flag = true;
                ArrayList drops = block.getBlockDropped(this.func_70314_l(), check.intX(), check.intY(), check.intZ(), candidateMeta, 0);
                for (ItemStack stack : drops) {
                    ItemStack insert = stack.func_77946_l();
                    insert = this.getInvHandler().storeItem(insert, new ForgeDirection[]{this.getDirection().getOpposite()});
                    if (insert == null) continue;
                    this.getInvHandler().throwItem(this.getDirection().getOpposite(), insert);
                }
                ResonantInduction.proxy.renderBlockParticle(this.field_70331_k, (double)check.intX(), (double)check.intY(), (double)check.intZ(), new Vector3((Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0), this.world().func_72798_a(check.intX(), check.intY(), check.intZ()), 1.0f);
                this.func_70314_l().func_94578_a(check.intX(), check.intY(), check.intZ(), false);
                this.func_70314_l().func_72926_e(1012, check.intX(), check.intY(), check.intZ(), 0);
            }
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{nbt});
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IBlockAccess access, int side) {
        int meta = access.func_72805_g(this.x(), this.y(), this.z());
        if (side == meta) {
            return iconFront;
        }
        if (side == (meta ^ 1)) {
            return iconBack;
        }
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        if (side == (meta ^ 1)) {
            return iconFront;
        }
        if (side == meta) {
            return iconBack;
        }
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        super.registerIcons(iconRegister);
        iconFront = iconRegister.func_94245_a(this.getTextureName() + "_front");
        iconBack = iconRegister.func_94245_a(this.getTextureName() + "_back");
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new RotatedTextureRenderer((TileBlock)this);
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

