/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.mechanical.process.purifier;

import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.IFluidBlock;
import resonant.api.IMechanicalNode;
import resonant.api.grid.INodeProvider;
import resonant.api.recipe.MachineRecipes;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Timer;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.fluid.BlockFluidMixture;
import resonantinduction.mechanical.energy.grid.TileMechanical;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class TileMixer
extends TileMechanical
implements IInventory {
    public static final long POWER = 500000L;
    public static final int PROCESS_TIME = 240;
    public static final Timer<EntityItem> timer = new Timer();
    private boolean areaBlockedFromMoving = false;

    public TileMixer() {
        super(Material.field_76243_f);
        this.mechanicalNode = new TileMechanical.PacketMechanicalNode((INodeProvider)this){

            @Override
            public boolean inverseRotation(ForgeDirection dir, IMechanicalNode with) {
                return dir == ForgeDirection.DOWN;
            }
        }.setConnection(Byte.parseByte("000011", 2));
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.customItemRender = true;
        this.textureName = "material_metal_top";
    }

    @Override
    public void func_70316_g() {
        if (!this.world().field_72995_K && this.ticks % 20L == 0L) {
            this.areaBlockedFromMoving = false;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int id;
                    Block block;
                    if (x == 0 || z == 0 || (block = Block.field_71973_m[id = this.position().translate((double)x, 0.0, (double)z).getBlockID((IBlockAccess)this.world())]) == null || block instanceof IFluidBlock || block instanceof BlockFluid) continue;
                    this.areaBlockedFromMoving = true;
                    return;
                }
            }
        }
        super.func_70316_g();
        if (this.canWork()) {
            this.doWork();
        }
    }

    public boolean canWork() {
        return this.mechanicalNode.getAngularVelocity() != 0.0 && this.areaBlockedFromMoving;
    }

    public void doWork() {
        boolean didWork = false;
        AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 2), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 2));
        List entities = this.field_70331_k.func_72872_a(Entity.class, aabb);
        LinkedHashSet<EntityItem> processItems = new LinkedHashSet<EntityItem>();
        for (Entity entity : entities) {
            Vector3 originalPosition = new Vector3(entity);
            Vector3 relativePosition = originalPosition.clone().subtract((IVector3)new Vector3((TileEntity)this).add(0.5));
            relativePosition.rotate(-this.mechanicalNode.getAngularVelocity(), 0.0, 0.0);
            Vector3 newPosition = new Vector3((TileEntity)this).add(0.5).add((IVector3)relativePosition);
            Vector3 difference = newPosition.difference((IVector3)originalPosition).scale(0.5);
            entity.func_70024_g(difference.x, difference.y, difference.z);
            entity.field_70122_E = false;
            if (!(entity instanceof EntityItem) || MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.MIXER.name(), new Object[]{((EntityItem)entity).func_92059_d()}).length <= 0) continue;
            processItems.add((EntityItem)entity);
        }
        for (EntityItem processingItem : processItems) {
            if (!timer.containsKey((Object)processingItem)) {
                timer.put((Object)processingItem, 240);
            }
            if (!processingItem.field_70128_L) {
                Vector3 vector3 = new Vector3((TileEntity)this);
                if (vector3.add(0.5).distance((Entity)processingItem) < 2.0) {
                    int timeLeft = timer.decrease((Object)processingItem);
                    if (timeLeft <= 0) {
                        if (this.doneWork(processingItem)) {
                            if (--processingItem.func_92059_d().field_77994_a <= 0) {
                                processingItem.func_70106_y();
                                timer.remove((Object)processingItem);
                            } else {
                                processingItem.func_92058_a(processingItem.func_92059_d());
                                timer.put((Object)processingItem, 240);
                            }
                        }
                    } else {
                        processingItem.field_70293_c = 20;
                        this.field_70331_k.func_72869_a("bubble", processingItem.field_70165_t, processingItem.field_70163_u, processingItem.field_70161_v, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0);
                    }
                    didWork = true;
                    continue;
                }
            }
            timer.remove((Object)processingItem);
        }
        if (didWork && this.ticks % 20L == 0L) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "resonantinduction:mixer", 0.5f, 1.0f);
        }
    }

    private boolean doneWork(EntityItem entity) {
        Vector3 mixPosition = new Vector3(entity.field_70165_t, (double)this.field_70330_m, entity.field_70161_v);
        if (mixPosition.getBlockID((IBlockAccess)this.world()) != this.blockID()) {
            Block block = Block.field_71973_m[mixPosition.getBlockID((IBlockAccess)this.field_70331_k)];
            BlockFluidFinite blockFluidFinite = ResourceGenerator.getMixture((String)ResourceGenerator.getName((ItemStack)entity.func_92059_d()));
            if (blockFluidFinite != null) {
                if (block instanceof BlockFluidMixture) {
                    ItemStack itemStack = entity.func_92059_d().func_77946_l();
                    if (((BlockFluidMixture)block).mix(this.field_70331_k, mixPosition.intX(), mixPosition.intY(), mixPosition.intZ(), itemStack)) {
                        this.field_70331_k.func_72898_h(mixPosition.intX(), mixPosition.intY(), mixPosition.intZ(), mixPosition.getBlockID((IBlockAccess)this.field_70331_k));
                        return true;
                    }
                } else if (block != null && (block.field_71990_ca == Block.field_71943_B.field_71990_ca || block.field_71990_ca == Block.field_71942_A.field_71990_ca)) {
                    mixPosition.setBlock(this.field_70331_k, blockFluidFinite.field_71990_ca);
                }
            }
        }
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (!this.field_70331_k.field_72995_K) {
            Vector3 spawnVector = new Vector3((TileEntity)this).translate(ForgeDirection.getOrientation((int)(this.field_70331_k.field_73012_v.nextInt(4) + 2))).translate(0.5);
            InventoryUtility.dropItemStack((World)this.field_70331_k, (Vector3)spawnVector, (ItemStack)itemstack, (int)20, (float)0.0f);
        }
    }

    public String func_70303_b() {
        return null;
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.MIXER.name(), new Object[]{itemstack}).length > 0;
    }
}

