/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import resonant.api.IElectromagnet;
import resonant.api.event.PlasmaEvent;
import resonant.api.recipe.QuantumAssemblerRecipes;
import resonant.core.content.debug.BlockCreativeBuilder;
import resonant.lib.content.ContentRegistry;
import resonant.lib.flag.FlagRegistry;
import resonant.lib.modproxy.ProxyHandler;
import resonant.lib.network.PacketAnnotation;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.block.BlockRadioactive;
import resonant.lib.prefab.ore.OreGenBase;
import resonant.lib.prefab.ore.OreGenReplaceStone;
import resonant.lib.prefab.ore.OreGenerator;
import resonant.lib.recipe.UniversalRecipe;
import resonant.lib.render.RenderUtility;
import resonant.lib.schematic.Schematic;
import resonant.lib.thermal.EventThermal;
import resonantinduction.atomic.CommonProxy;
import resonantinduction.atomic.base.ItemCell;
import resonantinduction.atomic.fission.BlockUraniumOre;
import resonantinduction.atomic.fission.ItemBreederFuel;
import resonantinduction.atomic.fission.ItemFissileFuel;
import resonantinduction.atomic.fission.ItemRadioactive;
import resonantinduction.atomic.fission.ItemUranium;
import resonantinduction.atomic.fission.reactor.BlockToxicWaste;
import resonantinduction.atomic.fission.reactor.TileControlRod;
import resonantinduction.atomic.fission.reactor.TileReactorCell;
import resonantinduction.atomic.fusion.BlockPlasmaHeater;
import resonantinduction.atomic.fusion.TileElectromagnet;
import resonantinduction.atomic.fusion.TilePlasma;
import resonantinduction.atomic.fusion.TilePlasmaHeater;
import resonantinduction.atomic.particle.accelerator.BlockAccelerator;
import resonantinduction.atomic.particle.accelerator.EntityParticle;
import resonantinduction.atomic.particle.accelerator.ItemDarkMatter;
import resonantinduction.atomic.particle.accelerator.TileAccelerator;
import resonantinduction.atomic.particle.fulmination.FulminationHandler;
import resonantinduction.atomic.particle.fulmination.ItemAntimatter;
import resonantinduction.atomic.particle.fulmination.TileFulmination;
import resonantinduction.atomic.particle.quantum.TileQuantumAssembler;
import resonantinduction.atomic.process.BlockChemicalExtractor;
import resonantinduction.atomic.process.ItemHazmat;
import resonantinduction.atomic.process.TileChemicalExtractor;
import resonantinduction.atomic.process.fission.BlockCentrifuge;
import resonantinduction.atomic.process.fission.BlockNuclearBoiler;
import resonantinduction.atomic.process.fission.TileCentrifuge;
import resonantinduction.atomic.process.fission.TileNuclearBoiler;
import resonantinduction.atomic.process.sensor.TileSiren;
import resonantinduction.atomic.process.sensor.TileThermometer;
import resonantinduction.atomic.process.turbine.BlockElectricTurbine;
import resonantinduction.atomic.process.turbine.TileElectricTurbine;
import resonantinduction.atomic.process.turbine.TileFunnel;
import resonantinduction.atomic.schematic.SchematicAccelerator;
import resonantinduction.atomic.schematic.SchematicBreedingReactor;
import resonantinduction.atomic.schematic.SchematicFissionReactor;
import resonantinduction.atomic.schematic.SchematicFusionReactor;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import resonantinduction.core.TabRI;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

@Mod(modid="ResonantInduction|Atomic", name="Resonant Induction Atomic", version="0.3.1", dependencies="required-after:ResonantEngine;after:IC2;after:ResonantInduction|Electrical;required-after:ResonantInduction|Core")
@NetworkMod(channels={"resonindc"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class Atomic {
    public static final String ID = "ResonantInduction|Atomic";
    public static final String TEXTURE_DIRECTORY = "textures/";
    public static final String GUI_TEXTURE_DIRECTORY = "textures/gui/";
    public static final int ENTITY_ID_PREFIX = 49;
    public static final int SECOND_IN_TICKS = 20;
    public static final EnumArmorMaterial hazmatArmorMaterial = EnumHelper.addArmorMaterial((String)"HAZMAT", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0);
    public static final String BAN_ANTIMATTER_POWER = FlagRegistry.registerFlag((String)"ban_antimatter_power");
    public static final String NAME = "Resonant Induction Atomic";
    public static final ContentRegistry contentRegistry = new ContentRegistry(Settings.CONFIGURATION, Settings.idManager, "ResonantInduction|Atomic").setPrefix("resonantinduction:").setTab((CreativeTabs)TabRI.DEFAULT);
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"en_US", "pl_PL", "de_DE", "ru_RU"};
    @Mod.Instance(value="ResonantInduction|Atomic")
    public static Atomic INSTANCE;
    @SidedProxy(clientSide="resonantinduction.atomic.ClientProxy", serverSide="resonantinduction.atomic.CommonProxy")
    public static CommonProxy proxy;
    public ProxyHandler modproxies;
    @Mod.Metadata(value="ResonantInduction|Atomic")
    public static ModMetadata metadata;
    public static Block blockRadioactive;
    public static Block blockCentrifuge;
    public static Block blockElectricTurbine;
    public static Block blockNuclearBoiler;
    public static Block blockControlRod;
    public static Block blockThermometer;
    public static Block blockFusionCore;
    public static Block blockPlasma;
    public static Block blockElectromagnet;
    public static Block blockChemicalExtractor;
    public static Block blockSiren;
    public static Block blockSteamFunnel;
    public static Block blockAccelerator;
    public static Block blockFulmination;
    public static Block blockQuantumAssembler;
    public static Block blockReactorCell;
    public static Item itemCell;
    public static Item itemFissileFuel;
    public static Item itemBreedingRod;
    public static Item itemDarkMatter;
    public static Item itemAntimatter;
    public static Item itemDeuteriumCell;
    public static Item itemTritiumCell;
    public static Item itemWaterCell;
    public static Item itemBucketToxic;
    public static Block blockUraniumOre;
    public static Item itemYellowCake;
    public static Item itemUranium;
    public static Item itemHazmatTop;
    public static Item itemHazmatBody;
    public static Item itemHazmatLeggings;
    public static Item itemHazmatBoots;
    public static Block blockToxicWaste;
    public static FluidStack FLUIDSTACK_WATER;
    public static FluidStack FLUIDSTACK_URANIUM_HEXAFLOURIDE;
    public static FluidStack FLUIDSTACK_STEAM;
    public static FluidStack FLUIDSTACK_DEUTERIUM;
    public static FluidStack FLUIDSTACK_TRITIUM;
    public static FluidStack FLUIDSTACK_TOXIC_WASTE;
    public static Fluid FLUID_URANIUM_HEXAFLOURIDE;
    public static Fluid FLUID_PLASMA;
    public static Fluid FLUID_STEAM;
    public static Fluid FLUID_DEUTERIUM;
    public static Fluid FLUID_TRITIUM;
    public static Fluid FLUID_TOXIC_WASTE;
    public static OreGenBase uraniumOreGeneration;

    public static boolean isItemStackEmptyCell(ItemStack itemStack) {
        return Atomic.isItemStackOreDictionaryCompatible(itemStack, "cellEmpty");
    }

    public static boolean isItemStackWaterCell(ItemStack itemStack) {
        return Atomic.isItemStackOreDictionaryCompatible(itemStack, "cellWater");
    }

    public static boolean isItemStackUraniumOre(ItemStack itemStack) {
        return Atomic.isItemStackOreDictionaryCompatible(itemStack, "dropUranium", "oreUranium");
    }

    public static boolean isItemStackDeuteriumCell(ItemStack itemStack) {
        return Atomic.isItemStackOreDictionaryCompatible(itemStack, "molecule_1d", "molecule_1h2", "cellDeuterium");
    }

    public static boolean isItemStackTritiumCell(ItemStack itemStack) {
        return Atomic.isItemStackOreDictionaryCompatible(itemStack, "molecule_h3", "cellTritium");
    }

    public static boolean isItemStackOreDictionaryCompatible(ItemStack itemStack, String ... names) {
        if (itemStack != null && names != null && names.length > 0) {
            String name = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack));
            for (String compareName : names) {
                if (!name.equals(compareName)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFluidAmount(FluidStack fluid) {
        if (fluid != null) {
            return fluid.amount;
        }
        return 0;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modproxies = new ProxyHandler();
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        PacketAnnotation.register(TileElectricTurbine.class);
        PacketAnnotation.register(TileReactorCell.class);
        PacketAnnotation.register(TileThermometer.class);
        BlockCreativeBuilder.register((Schematic)new SchematicAccelerator());
        BlockCreativeBuilder.register((Schematic)new SchematicBreedingReactor());
        BlockCreativeBuilder.register((Schematic)new SchematicFissionReactor());
        BlockCreativeBuilder.register((Schematic)new SchematicFusionReactor());
        Settings.CONFIGURATION.load();
        PacketAnnotation.register(TileAccelerator.class);
        PacketAnnotation.register(TileChemicalExtractor.class);
        PacketAnnotation.register(TileNuclearBoiler.class);
        PacketAnnotation.register(TileElectricTurbine.class);
        FLUID_URANIUM_HEXAFLOURIDE = new Fluid("uraniumhexafluoride").setGaseous(true);
        FLUID_STEAM = new Fluid("steam").setGaseous(true);
        FLUID_DEUTERIUM = new Fluid("deuterium").setGaseous(true);
        FLUID_TRITIUM = new Fluid("tritium").setGaseous(true);
        FLUID_TOXIC_WASTE = new Fluid("toxicwaste");
        FLUID_PLASMA = new Fluid("plasma").setGaseous(true);
        FluidRegistry.registerFluid((Fluid)FLUID_URANIUM_HEXAFLOURIDE);
        FluidRegistry.registerFluid((Fluid)FLUID_STEAM);
        FluidRegistry.registerFluid((Fluid)FLUID_TRITIUM);
        FluidRegistry.registerFluid((Fluid)FLUID_DEUTERIUM);
        FluidRegistry.registerFluid((Fluid)FLUID_TOXIC_WASTE);
        FluidRegistry.registerFluid((Fluid)FLUID_PLASMA);
        FLUIDSTACK_WATER = new FluidStack(FluidRegistry.WATER, 0);
        FLUIDSTACK_URANIUM_HEXAFLOURIDE = new FluidStack(FLUID_URANIUM_HEXAFLOURIDE, 0);
        FLUIDSTACK_STEAM = new FluidStack(FluidRegistry.getFluidID((String)"steam"), 0);
        FLUIDSTACK_DEUTERIUM = new FluidStack(FluidRegistry.getFluidID((String)"deuterium"), 0);
        FLUIDSTACK_TRITIUM = new FluidStack(FluidRegistry.getFluidID((String)"tritium"), 0);
        FLUIDSTACK_TOXIC_WASTE = new FluidStack(FluidRegistry.getFluidID((String)"toxicwaste"), 0);
        blockRadioactive = contentRegistry.createBlock(BlockRadioactive.class).func_71864_b("resonantinduction:radioactive").func_111022_d("resonantinduction:radioactive").func_71849_a((CreativeTabs)TabRI.DEFAULT);
        blockUraniumOre = contentRegistry.createBlock(BlockUraniumOre.class);
        blockElectricTurbine = contentRegistry.createTile(BlockElectricTurbine.class, TileElectricTurbine.class);
        blockCentrifuge = contentRegistry.createTile(BlockCentrifuge.class, TileCentrifuge.class);
        blockReactorCell = contentRegistry.newBlock(TileReactorCell.class);
        blockNuclearBoiler = contentRegistry.createTile(BlockNuclearBoiler.class, TileNuclearBoiler.class);
        blockChemicalExtractor = contentRegistry.createTile(BlockChemicalExtractor.class, TileChemicalExtractor.class);
        blockFusionCore = contentRegistry.createTile(BlockPlasmaHeater.class, TilePlasmaHeater.class);
        blockControlRod = contentRegistry.newBlock(TileControlRod.class);
        blockThermometer = contentRegistry.newBlock(TileThermometer.class);
        blockPlasma = contentRegistry.newBlock(TilePlasma.class);
        blockElectromagnet = contentRegistry.newBlock(TileElectromagnet.class);
        blockSiren = contentRegistry.newBlock(TileSiren.class);
        blockSteamFunnel = contentRegistry.newBlock(TileFunnel.class);
        blockAccelerator = contentRegistry.createTile(BlockAccelerator.class, TileAccelerator.class);
        blockFulmination = contentRegistry.newBlock(TileFulmination.class);
        blockQuantumAssembler = contentRegistry.newBlock(TileQuantumAssembler.class);
        blockToxicWaste = contentRegistry.createBlock(BlockToxicWaste.class).func_71849_a(null);
        itemHazmatTop = new ItemHazmat(Settings.CONFIGURATION.getItem("HazmatTop", Settings.getNextItemID()).getInt(), hazmatArmorMaterial, proxy.getArmorIndex("hazmat"), 0).func_77655_b("resonantinduction:hazmatMask");
        itemHazmatBody = new ItemHazmat(Settings.CONFIGURATION.getItem("HazmatBody", Settings.getNextItemID()).getInt(), hazmatArmorMaterial, proxy.getArmorIndex("hazmat"), 1).func_77655_b("resonantinduction:hazmatBody");
        itemHazmatLeggings = new ItemHazmat(Settings.CONFIGURATION.getItem("HazmatBottom", Settings.getNextItemID()).getInt(), hazmatArmorMaterial, proxy.getArmorIndex("hazmat"), 2).func_77655_b("resonantinduction:hazmatLeggings");
        itemHazmatBoots = new ItemHazmat(Settings.CONFIGURATION.getItem("HazmatBoots", Settings.getNextItemID()).getInt(), hazmatArmorMaterial, proxy.getArmorIndex("hazmat"), 3).func_77655_b("resonantinduction:hazmatBoots");
        itemCell = contentRegistry.createItem("cellEmpty", Item.class);
        itemFissileFuel = contentRegistry.createItem("rodFissileFuel", ItemFissileFuel.class);
        itemDeuteriumCell = contentRegistry.createItem("cellDeuterium", ItemCell.class);
        itemTritiumCell = contentRegistry.createItem("cellTritium", ItemCell.class);
        itemWaterCell = contentRegistry.createItem("cellWater", ItemCell.class);
        itemDarkMatter = contentRegistry.createItem("darkMatter", ItemDarkMatter.class);
        itemAntimatter = contentRegistry.createItem("antimatter", ItemAntimatter.class);
        itemBreedingRod = contentRegistry.createItem("rodBreederFuel", ItemBreederFuel.class);
        itemYellowCake = contentRegistry.createItem("yellowcake", ItemRadioactive.class);
        itemUranium = contentRegistry.createItem(ItemUranium.class);
        FLUID_PLASMA.setBlockID(blockPlasma);
        int bucketID = Settings.getNextItemID();
        itemBucketToxic = new ItemBucket(Settings.CONFIGURATION.getItem("Toxic Waste Bucket", bucketID).getInt(bucketID), Atomic.blockToxicWaste.field_71990_ca).func_77637_a((CreativeTabs)TabRI.DEFAULT).func_77655_b("resonantinduction:bucketToxicWaste").func_77642_a(Item.field_77788_aw).func_111206_d("resonantinduction:bucketToxicWaste");
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.getFluid((String)"toxicwaste"), (ItemStack)new ItemStack(itemBucketToxic), (ItemStack)new ItemStack(Item.field_77788_aw));
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.WATER, (ItemStack)new ItemStack(itemWaterCell), (ItemStack)new ItemStack(itemCell));
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"deuterium"), 200), (ItemStack)new ItemStack(itemDeuteriumCell), (ItemStack)new ItemStack(itemCell));
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"tritium"), 200), (ItemStack)new ItemStack(itemTritiumCell), (ItemStack)new ItemStack(itemCell));
        if (OreDictionary.getOres((String)"oreUranium").size() > 1 && Settings.CONFIGURATION.get("general", "Auto Disable Uranium If Exist", false).getBoolean(false)) {
            ResonantInduction.LOGGER.fine("Disabled Uranium Generation. Detected another uranium being generated: " + OreDictionary.getOres((String)"oreUranium").size());
        } else {
            uraniumOreGeneration = new OreGenReplaceStone("Uranium Ore", "oreUranium", new ItemStack(blockUraniumOre), 0, 25, 9, 3, "pickaxe", 2);
            uraniumOreGeneration.enable(Settings.CONFIGURATION);
            OreGenerator.addOre((OreGenBase)uraniumOreGeneration);
            ResonantInduction.LOGGER.fine("Added Atomic Science uranium to ore generator.");
        }
        Settings.CONFIGURATION.save();
        MinecraftForge.EVENT_BUS.register((Object)itemAntimatter);
        MinecraftForge.EVENT_BUS.register((Object)FulminationHandler.INSTANCE);
        if (Settings.allowOreDictionaryCompatibility) {
            OreDictionary.registerOre((String)"ingotUranium", (Item)itemUranium);
            OreDictionary.registerOre((String)"dustUranium", (Item)itemYellowCake);
        }
        OreDictionary.registerOre((String)"breederUranium", (ItemStack)new ItemStack(itemUranium, 1, 1));
        OreDictionary.registerOre((String)"blockRadioactive", (Block)blockRadioactive);
        OreDictionary.registerOre((String)"cellEmpty", (Item)itemCell);
        OreDictionary.registerOre((String)"cellUranium", (Item)itemFissileFuel);
        OreDictionary.registerOre((String)"cellTritium", (Item)itemTritiumCell);
        OreDictionary.registerOre((String)"cellDeuterium", (Item)itemDeuteriumCell);
        OreDictionary.registerOre((String)"cellWater", (Item)itemWaterCell);
        OreDictionary.registerOre((String)"strangeMatter", (Item)itemDarkMatter);
        OreDictionary.registerOre((String)"antimatterMilligram", (ItemStack)new ItemStack(itemAntimatter, 1, 0));
        OreDictionary.registerOre((String)"antimatterGram", (ItemStack)new ItemStack(itemAntimatter, 1, 1));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                for (ForgeChunkManager.Ticket ticket : tickets) {
                    if (ticket.getType() != ForgeChunkManager.Type.ENTITY || ticket.getEntity() == null || !(ticket.getEntity() instanceof EntityParticle)) continue;
                    ((EntityParticle)ticket.getEntity()).updateTicket = ticket;
                }
            }
        });
        proxy.preInit();
        Settings.CONFIGURATION.save();
        TabRI.ITEMSTACK = new ItemStack(blockReactorCell);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        Settings.setModMetadata((ModMetadata)metadata, (String)ID, (String)NAME, (String)"ResonantInduction|Core");
        proxy.init();
        this.modproxies.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"IC2") && Settings.allowAlternateRecipes) {
            OreDictionary.registerOre((String)"cellEmpty", (ItemStack)Items.getItem((String)"cell"));
            String string = OreDictionary.getOreName((int)OreDictionary.getOreID((String)"cellEmpty"));
            if (string == "Unknown") {
                ResonantInduction.LOGGER.info("Unable to register cellEmpty in OreDictionary!");
            }
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemYellowCake, new Object[]{Items.getItem((String)"reactorUraniumSimple")}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.getItem((String)"cell"), new Object[]{itemCell}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemCell, new Object[]{"cellEmpty"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemAntimatter, 1, 1), new Object[]{itemAntimatter, itemAntimatter, itemAntimatter, itemAntimatter, itemAntimatter, itemAntimatter, itemAntimatter, itemAntimatter}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemAntimatter, 8, 0), new Object[]{new ItemStack(itemAntimatter, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSteamFunnel, 2), new Object[]{" B ", "B B", "B B", Character.valueOf('B'), UniversalRecipe.SECONDARY_METAL.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSteamFunnel, 2), new Object[]{" B ", "B B", "B B", Character.valueOf('B'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockQuantumAssembler, new Object[]{"CCC", "SXS", "SSS", Character.valueOf('X'), blockCentrifuge, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockFulmination, new Object[]{"OSO", "SCS", "OSO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockAccelerator, new Object[]{"SCS", "CMC", "SCS", Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockCentrifuge, new Object[]{"BSB", "MCM", "BSB", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('B'), UniversalRecipe.SECONDARY_METAL.get(Settings.allowAlternateRecipes), Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockNuclearBoiler, new Object[]{"S S", "FBF", "SMS", Character.valueOf('F'), Block.field_72051_aB, Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('B'), Item.field_77788_aw, Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockChemicalExtractor, new Object[]{"BSB", "MCM", "BSB", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('B'), UniversalRecipe.SECONDARY_METAL.get(Settings.allowAlternateRecipes), Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSiren, 2), new Object[]{"NPN", Character.valueOf('N'), Block.field_71960_R, Character.valueOf('P'), UniversalRecipe.SECONDARY_PLATE.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockReactorCell, new Object[]{"SCS", "MEM", "SCS", Character.valueOf('E'), "cellEmpty", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(Settings.allowAlternateRecipes), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockFusionCore, new Object[]{"CPC", "PFP", "CPC", Character.valueOf('P'), UniversalRecipe.PRIMARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('F'), blockReactorCell, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockElectricTurbine, new Object[]{" B ", "BMB", " B ", Character.valueOf('B'), UniversalRecipe.SECONDARY_PLATE.get(Settings.allowAlternateRecipes), Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemCell, 16), new Object[]{" T ", "TGT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('G'), Block.field_71946_M}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemWaterCell), new Object[]{"cellEmpty", Item.field_77786_ax}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockThermometer, new Object[]{"SSS", "GCG", "GSG", Character.valueOf('S'), UniversalRecipe.PRIMARY_METAL.get(Settings.allowAlternateRecipes), Character.valueOf('G'), Block.field_71946_M, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(blockControlRod, new Object[]{"I", "I", "I", Character.valueOf('I'), Item.field_77703_o}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemFissileFuel, new Object[]{"CUC", "CUC", "CUC", Character.valueOf('U'), "ingotUranium", Character.valueOf('C'), "cellEmpty"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemBreedingRod, new Object[]{"CUC", "CUC", "CUC", Character.valueOf('U'), "breederUranium", Character.valueOf('C'), "cellEmpty"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockElectromagnet, 2, 0), new Object[]{"BBB", "BMB", "BBB", Character.valueOf('B'), UniversalRecipe.SECONDARY_METAL.get(Settings.allowAlternateRecipes), Character.valueOf('M'), UniversalRecipe.MOTOR.get(Settings.allowAlternateRecipes)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(blockElectromagnet, 1, 1), new Object[]{blockElectromagnet, Block.field_71946_M}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemHazmatTop, new Object[]{"SSS", "BAB", "SCS", Character.valueOf('A'), Item.field_77687_V, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(Settings.allowAlternateRecipes), Character.valueOf('S'), Block.field_72101_ab}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemHazmatBody, new Object[]{"SSS", "BAB", "SCS", Character.valueOf('A'), Item.field_77686_W, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(Settings.allowAlternateRecipes), Character.valueOf('S'), Block.field_72101_ab}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemHazmatLeggings, new Object[]{"SSS", "BAB", "SCS", Character.valueOf('A'), Item.field_77693_X, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(Settings.allowAlternateRecipes), Character.valueOf('S'), Block.field_72101_ab}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemHazmatBoots, new Object[]{"SSS", "BAB", "SCS", Character.valueOf('A'), Item.field_77692_Y, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(Settings.allowAlternateRecipes), Character.valueOf('S'), Block.field_72101_ab}));
        EntityRegistry.registerGlobalEntityID(EntityParticle.class, (String)"ASParticle", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityParticle.class, (String)"ASParticle", (int)49, (Object)this, (int)80, (int)3, (boolean)true);
        proxy.init();
        Settings.CONFIGURATION.load();
        if (Loader.isModLoaded((String)"IC2") && Settings.allowAlternateRecipes && Settings.allowIC2UraniumCompression) {
            try {
                if (Recipes.compressor != null) {
                    Map map = Recipes.compressor.getRecipes();
                    Iterator it = map.entrySet().iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        for (ItemStack checkStack : ((IRecipeInput)entry.getKey()).getInputs()) {
                            if (!Atomic.isItemStackUraniumOre(checkStack)) continue;
                            ++i;
                            it.remove();
                        }
                    }
                    ResonantInduction.LOGGER.fine("Removed " + i + " IC2 uranium compression recipe, use centrifuge instead.");
                }
            }
            catch (Exception exception) {
                ResonantInduction.LOGGER.fine("Failed to remove IC2 compressor recipes.");
                exception.printStackTrace();
            }
        }
        if (Settings.quantumAssemblerGenerateMode > 0) {
            ItemStack itemStack;
            for (Item item : Item.field_77698_e) {
                if (item == null || item.field_77779_bT <= 256 && Settings.quantumAssemblerGenerateMode != 2 || (itemStack = new ItemStack(item)) == null) continue;
                QuantumAssemblerRecipes.addRecipe((ItemStack)itemStack);
            }
            if (Settings.quantumAssemblerGenerateMode == 2) {
                for (Block block : Block.field_71973_m) {
                    if (block == null || (itemStack = new ItemStack(block)) == null) continue;
                    QuantumAssemblerRecipes.addRecipe((ItemStack)itemStack);
                }
            }
            for (String string : OreDictionary.getOreNames()) {
                if (!string.startsWith("ingot")) continue;
                for (ItemStack itemStack2 : OreDictionary.getOres((String)string)) {
                    if (itemStack2 == null) continue;
                    QuantumAssemblerRecipes.addRecipe((ItemStack)itemStack2);
                }
            }
        }
        Settings.CONFIGURATION.save();
    }

    @ForgeSubscribe
    public void thermalEventHandler(EventThermal.EventThermalUpdate evt) {
        VectorWorld pos = evt.position;
        Block block = Block.field_71973_m[pos.getBlockID()];
        if (block == blockElectromagnet) {
            evt.heatLoss = evt.deltaTemperature * 0.6f;
        }
    }

    @ForgeSubscribe
    public void plasmaEvent(PlasmaEvent.SpawnPlasmaEvent evt) {
        TileEntity tile;
        Vector3 position = new Vector3((double)evt.x, (double)evt.y, (double)evt.z);
        World world = evt.world;
        int blockID = position.getBlockID((IBlockAccess)world);
        Block block = Block.field_71973_m[blockID];
        if (block != null) {
            if (block.field_71990_ca == Block.field_71986_z.field_71990_ca || block.field_71990_ca == Block.field_72083_ai.field_71990_ca) {
                return;
            }
            tile = position.getTileEntity((IBlockAccess)world);
            if (tile instanceof TilePlasma) {
                ((TilePlasma)tile).setTemperature(evt.temperature);
                return;
            }
            if (tile instanceof IElectromagnet) {
                return;
            }
        }
        position.setBlock(world, Atomic.blockPlasma.field_71990_ca);
        tile = position.getTileEntity((IBlockAccess)world);
        if (tile instanceof TilePlasma) {
            ((TilePlasma)tile).setTemperature(evt.temperature);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void preTextureHook(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 0) {
            RenderUtility.registerIcon((String)"resonantinduction:uraniumHexafluoride", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:steam", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:deuterium", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:tritium", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:atomic_edge", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:funnel_edge", (TextureMap)event.map);
            RenderUtility.registerIcon((String)"resonantinduction:glass", (TextureMap)event.map);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void postTextureHook(TextureStitchEvent.Post event) {
        FLUID_URANIUM_HEXAFLOURIDE.setIcons((Icon)RenderUtility.loadedIconMap.get("resonantinduction:uraniumHexafluoride"));
        FLUID_STEAM.setIcons((Icon)RenderUtility.loadedIconMap.get("resonantinduction:steam"));
        FLUID_DEUTERIUM.setIcons((Icon)RenderUtility.loadedIconMap.get("resonantinduction:deuterium"));
        FLUID_TRITIUM.setIcons((Icon)RenderUtility.loadedIconMap.get("resonantinduction:tritium"));
        FLUID_TOXIC_WASTE.setIcons(blockToxicWaste.func_71858_a(0, 0));
        FLUID_PLASMA.setIcons(blockPlasma.func_71858_a(0, 0));
    }

    @ForgeSubscribe
    public void fillBucketEvent(FillBucketEvent evt) {
        Vector3 blockPos;
        int blockID;
        if (!evt.world.field_72995_K && evt.target != null && evt.target.field_72313_a == EnumMovingObjectType.TILE && (blockID = (blockPos = new Vector3(evt.target)).getBlockID((IBlockAccess)evt.world)) == Atomic.blockToxicWaste.field_71990_ca) {
            blockPos.setBlock(evt.world, 0);
            evt.result = new ItemStack(itemBucketToxic);
            evt.setResult(Event.Result.ALLOW);
        }
    }

    public static enum RecipeType {
        CHEMICAL_EXTRACTOR;

    }
}

