/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.fission;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import resonant.api.IReactor;
import resonant.api.IReactorComponent;
import resonantinduction.atomic.Atomic;
import resonantinduction.atomic.fission.ItemRadioactive;
import resonantinduction.core.Settings;
import universalelectricity.api.vector.Vector3;

public class ItemFissileFuel
extends ItemRadioactive
implements IReactorComponent {
    public static final int DECAY = 2500;
    public static final int BREEDING_TEMP = 1200;
    public static final long ENERGY = 100000000000L;
    public static final long ENERGY_PER_TICK = 2000000L;

    public ItemFissileFuel(int itemID) {
        super(itemID);
        this.func_77625_d(1);
        this.func_77656_e(2500);
        this.setNoRepair();
    }

    public void onReact(ItemStack itemStack, IReactor reactor) {
        TileEntity tileEntity = (TileEntity)reactor;
        World worldObj = tileEntity.field_70331_k;
        int reactors = 0;
        for (int i = 0; i < 6; ++i) {
            Vector3 checkPos = new Vector3(tileEntity).translate(ForgeDirection.getOrientation((int)i));
            TileEntity tile = checkPos.getTileEntity((IBlockAccess)worldObj);
            if (!(tile instanceof IReactor) || !(((IReactor)tile).getTemperature() > 1200.0f)) continue;
            ++reactors;
        }
        if (reactors >= 2) {
            if (worldObj.field_73012_v.nextInt(1000) <= 100 && reactor.getTemperature() > 1200.0f) {
                int healAmt = worldObj.field_73012_v.nextInt(5);
                itemStack.func_77964_b(Math.max(itemStack.func_77960_j() - healAmt, 0));
            }
        } else {
            reactor.heat(2000000L);
            if (reactor.world().func_72820_D() % 20L == 0L) {
                itemStack.func_77964_b(Math.min(itemStack.func_77960_j() + 1, itemStack.func_77958_k()));
            }
            if (Settings.allowToxicWaste && (double)worldObj.field_73012_v.nextFloat() > 0.5) {
                FluidStack fluid = Atomic.FLUIDSTACK_TOXIC_WASTE.copy();
                fluid.amount = 1;
                reactor.fill(ForgeDirection.UNKNOWN, fluid, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, this.func_77612_l() - 1));
    }
}

