/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.fission.reactor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IReactor;
import resonant.api.IReactorComponent;
import resonant.api.event.PlasmaEvent;
import resonant.lib.content.module.prefab.TileInventory;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.multiblock.MultiBlockHandler;
import resonant.lib.network.PacketHandler;
import resonant.lib.network.Synced;
import resonant.lib.prefab.poison.PoisonRadiation;
import resonant.lib.thermal.ThermalGrid;
import resonant.lib.thermal.ThermalPhysics;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.atomic.Atomic;
import resonantinduction.atomic.ReactorExplosion;
import resonantinduction.atomic.fusion.TilePlasma;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class TileReactorCell
extends TileInventory
implements IMultiBlockStructure<TileReactorCell>,
IInventory,
IReactor,
IFluidHandler,
ISidedInventory {
    public static final int RADIUS = 2;
    public static final int MELTING_POINT = 2000;
    private final int specificHeatCapacity = 1000;
    private final float mass = ThermalPhysics.getMass((float)1000.0f, (float)7.0f);
    public FluidTank tank = new FluidTank(15000);
    @Synced
    public float temperature = 295.0f;
    private float previousTemperature = 295.0f;
    private boolean shouldUpdate = false;
    private long prevInternalEnergy = 0L;
    private long internalEnergy = 0L;
    private int meltdownCounter = 0;
    private int meltdownCounterMaximum = 1000;
    private MultiBlockHandler<TileReactorCell> multiBlock;

    public TileReactorCell() {
        super(UniversalElectricity.machine);
        this.textureName = "machine";
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.customItemRender = true;
    }

    protected void onWorldJoin() {
        this.updatePositionStatus();
    }

    protected void onNeighborChanged() {
        this.updatePositionStatus();
    }

    public void initiate() {
        this.updatePositionStatus();
        super.initiate();
    }

    protected boolean use(EntityPlayer player, int side, Vector3 hit) {
        if (!this.world().field_72995_K) {
            TileReactorCell tile = (TileReactorCell)this.getMultiBlock().get();
            if (!player.func_70093_af()) {
                if (tile.func_70301_a(0) != null) {
                    InventoryUtility.dropItemStack((World)this.world(), (Vector3)new Vector3((Entity)player), (ItemStack)tile.func_70301_a(0), (int)0);
                    tile.func_70299_a(0, null);
                    return true;
                }
                if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof IReactorComponent) {
                    ItemStack itemStack = player.field_71071_by.func_70448_g().func_77946_l();
                    itemStack.field_77994_a = 1;
                    tile.func_70299_a(0, itemStack);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    return true;
                }
            }
            player.openGui((Object)Atomic.INSTANCE, 0, this.world(), tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }
        return true;
    }

    protected void markUpdate() {
        super.markUpdate();
        this.shouldUpdate = true;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.getMultiBlock().isPrimary()) {
            if (this.func_70301_a(0) != null && ((TileReactorCell)this.getMultiBlock().get()).func_70301_a(0) == null) {
                ((TileReactorCell)this.getMultiBlock().get()).func_70299_a(0, this.func_70301_a(0));
                this.func_70299_a(0, null);
            }
            if (this.tank.getFluidAmount() > 0) {
                ((TileReactorCell)this.getMultiBlock().get()).tank.fill(this.tank.drain(this.tank.getCapacity(), true), true);
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.getMultiBlock().isPrimary() && this.tank.getFluid() != null && this.tank.getFluid().fluidID == Atomic.FLUID_PLASMA.getID()) {
                FluidStack drain = this.tank.drain(1000, false);
                if (drain != null && drain.amount >= 1000) {
                    ForgeDirection spawnDir = ForgeDirection.getOrientation((int)(this.field_70331_k.field_73012_v.nextInt(3) + 2));
                    Vector3 spawnPos = new Vector3((TileEntity)this).translate(spawnDir, 2.0);
                    spawnPos.translate(0.0, (double)Math.max(this.field_70331_k.field_73012_v.nextInt(this.getHeight()) - 1, 0), 0.0);
                    if (this.field_70331_k.func_72799_c(spawnPos.intX(), spawnPos.intY(), spawnPos.intZ())) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlasmaEvent.SpawnPlasmaEvent(this.field_70331_k, spawnPos.intX(), spawnPos.intY(), spawnPos.intZ(), TilePlasma.plasmaMaxTemperature));
                        this.tank.drain(1000, true);
                    }
                }
            } else {
                this.prevInternalEnergy = this.internalEnergy;
                ItemStack fuelRod = ((TileReactorCell)this.getMultiBlock().get()).func_70301_a(0);
                if (fuelRod != null && fuelRod.func_77973_b() instanceof IReactorComponent) {
                    ((IReactorComponent)fuelRod.func_77973_b()).onReact(fuelRod, (IReactor)this);
                    if (!this.field_70331_k.field_72995_K && fuelRod.func_77960_j() >= fuelRod.func_77958_k()) {
                        ((TileReactorCell)this.getMultiBlock().get()).func_70299_a(0, null);
                    }
                    if (this.ticks % 20L == 0L && (double)this.field_70331_k.field_73012_v.nextFloat() > 0.65) {
                        List entities = this.field_70331_k.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 4), (double)(this.field_70330_m - 4), (double)(this.field_70327_n - 4), (double)(this.field_70329_l + 4), (double)(this.field_70330_m + 4), (double)(this.field_70327_n + 4)));
                        for (EntityLiving entity : entities) {
                            PoisonRadiation.INSTANCE.poisonEntity(new Vector3((TileEntity)this), (EntityLivingBase)entity);
                        }
                    }
                }
                this.temperature = ThermalGrid.getTemperature((VectorWorld)new VectorWorld((TileEntity)this));
                if (this.internalEnergy - this.prevInternalEnergy > 0L) {
                    float deltaT = ThermalPhysics.getTemperatureForEnergy((float)this.mass, (long)1000L, (long)((long)((double)(this.internalEnergy - this.prevInternalEnergy) * 0.15)));
                    int rods = 0;
                    for (int i = 2; i < 6; ++i) {
                        Vector3 checkAdjacent = new Vector3((TileEntity)this).translate(ForgeDirection.getOrientation((int)i));
                        if (checkAdjacent.getBlockID((IBlockAccess)this.field_70331_k) != Atomic.blockControlRod.field_71990_ca) continue;
                        deltaT = (float)((double)deltaT / 1.1);
                        ++rods;
                    }
                    ThermalGrid.addTemperature((VectorWorld)new VectorWorld((TileEntity)this), (float)deltaT);
                    if (this.field_70331_k.field_73012_v.nextInt(80) == 0 && this.getTemperature() >= 373.0f) {
                        this.field_70331_k.func_72908_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), "Fluid.lava", 0.5f, 2.1f + (this.field_70331_k.field_73012_v.nextFloat() - this.field_70331_k.field_73012_v.nextFloat()) * 0.85f);
                    }
                    if (this.field_70331_k.field_73012_v.nextInt(40) == 0 && this.getTemperature() >= 373.0f) {
                        this.field_70331_k.func_72908_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), "Fluid.lavapop", 0.5f, 2.6f + (this.field_70331_k.field_73012_v.nextFloat() - this.field_70331_k.field_73012_v.nextFloat()) * 0.8f);
                    }
                    if ((float)this.field_70331_k.func_72820_D() % 100.0f == 0.0f && this.getTemperature() >= 373.0f) {
                        float percentage = Math.min(this.getTemperature() / 2000.0f, 1.0f);
                        this.field_70331_k.func_72908_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), "resonantinduction:reactorcell", percentage, 1.0f);
                    }
                    if (this.previousTemperature != this.temperature && !this.shouldUpdate) {
                        this.shouldUpdate = true;
                        this.previousTemperature = this.temperature;
                    }
                    if (this.previousTemperature >= 2000.0f && this.meltdownCounter < this.meltdownCounterMaximum) {
                        this.shouldUpdate = true;
                        ++this.meltdownCounter;
                    } else if (this.previousTemperature >= 2000.0f && this.meltdownCounter >= this.meltdownCounterMaximum) {
                        this.meltdownCounter = 0;
                        this.meltDown();
                        return;
                    }
                    if (this.previousTemperature < 2000.0f && this.meltdownCounter < this.meltdownCounterMaximum && this.meltdownCounter > 0) {
                        --this.meltdownCounter;
                    }
                }
                this.internalEnergy = 0L;
                if (this.isOverToxic()) {
                    VectorWorld leakPos = new VectorWorld((TileEntity)this).translate((double)(this.field_70331_k.field_73012_v.nextInt(20) - 10), (double)(this.field_70331_k.field_73012_v.nextInt(20) - 10), (double)(this.field_70331_k.field_73012_v.nextInt(20) - 10));
                    int blockID = leakPos.getBlockID();
                    if (blockID == Block.field_71980_u.field_71990_ca) {
                        leakPos.setBlock(this.field_70331_k, Atomic.blockRadioactive.field_71990_ca);
                        this.tank.drain(1000, true);
                    } else if ((blockID == 0 || Block.field_71973_m[blockID].isBlockReplaceable(this.field_70331_k, leakPos.intX(), leakPos.intY(), leakPos.intZ())) && this.tank.getFluid() != null) {
                        leakPos.setBlock(this.field_70331_k, this.tank.getFluid().getFluid().getBlockID());
                        this.tank.drain(1000, true);
                    }
                }
            }
            if (this.ticks % 60L == 0L || this.shouldUpdate) {
                this.shouldUpdate = false;
                this.notifyChange();
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)50.0);
            }
        } else if (this.field_70331_k.field_73012_v.nextInt(5) == 0 && this.getTemperature() >= 373.0f) {
            this.field_70331_k.func_72869_a("cloud", (double)(this.field_70329_l + this.field_70331_k.field_73012_v.nextInt(2)), (double)((float)this.field_70330_m + 1.0f), (double)(this.field_70327_n + this.field_70331_k.field_73012_v.nextInt(2)), 0.0, 0.1, 0.0);
            this.field_70331_k.func_72869_a("bubble", (double)(this.field_70329_l + this.field_70331_k.field_73012_v.nextInt(5)), (double)this.field_70330_m, (double)(this.field_70327_n + this.field_70331_k.field_73012_v.nextInt(5)), 0.0, 0.0, 0.0);
        }
    }

    public boolean isOverToxic() {
        return this.tank.getFluid() != null && this.tank.getFluid().fluidID == Atomic.FLUID_TOXIC_WASTE.getID() && this.tank.getFluid().amount >= this.tank.getCapacity();
    }

    public void updatePositionStatus() {
        TileReactorCell mainTile = this.getLowest();
        mainTile.getMultiBlock().deconstruct();
        mainTile.getMultiBlock().construct();
        boolean top = new Vector3((TileEntity)this).add((IVector3)new Vector3(0.0, 1.0, 0.0)).getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileReactorCell;
        boolean bottom = new Vector3((TileEntity)this).add((IVector3)new Vector3(0.0, -1.0, 0.0)).getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileReactorCell;
        if (top && bottom) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, 3);
        } else if (top) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 3);
        } else {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, 3);
        }
    }

    public void onMultiBlockChanged() {
    }

    public Vector3[] getMultiBlockVectors() {
        TileEntity t;
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        Vector3 checkPosition = new Vector3((TileEntity)this);
        while ((t = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileReactorCell) {
            vectors.add(checkPosition.clone().subtract((IVector3)this.getPosition()));
            checkPosition.y += 1.0;
        }
        return vectors.toArray(new Vector3[0]);
    }

    public TileReactorCell getLowest() {
        TileEntity t;
        TileReactorCell lowest = this;
        Vector3 checkPosition = new Vector3((TileEntity)this);
        while ((t = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k)) instanceof TileReactorCell) {
            lowest = (TileReactorCell)t;
            checkPosition.y -= 1.0;
        }
        return lowest;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public Vector3 getPosition() {
        return new Vector3((TileEntity)this);
    }

    public MultiBlockHandler<TileReactorCell> getMultiBlock() {
        if (this.multiBlock == null) {
            this.multiBlock = new MultiBlockHandler((IMultiBlockStructure)this);
        }
        return this.multiBlock;
    }

    public int getHeight() {
        int height = 0;
        Vector3 checkPosition = new Vector3((TileEntity)this);
        TileReactorCell tile = this;
        while (tile instanceof TileReactorCell) {
            checkPosition.y += 1.0;
            ++height;
            tile = checkPosition.getTileEntity((IBlockAccess)this.field_70331_k);
        }
        return height;
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_ANNOTATION.getPacket((Object)this);
    }

    private void meltDown() {
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72832_d(Block.field_71938_D.field_71990_ca, 0, this.field_70329_l, this.field_70330_m, this.field_70327_n, 3);
            ReactorExplosion reactorExplosion = new ReactorExplosion(this.field_70331_k, null, this.field_70329_l, this.field_70330_m, this.field_70327_n, 9.0f);
            reactorExplosion.func_77278_a();
            reactorExplosion.func_77279_a(true);
        }
    }

    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.temperature = nbt.func_74760_g("temperature");
        this.tank.readFromNBT(nbt);
        this.getMultiBlock().load(nbt);
    }

    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74776_a("temperature", this.temperature);
        this.tank.writeToNBT(nbt);
        this.getMultiBlock().save(nbt);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_102007_a(int slot, ItemStack items, int side) {
        return this.func_94041_b(slot, items);
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public String func_70303_b() {
        return this.func_70311_o().func_71931_t();
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (this.getMultiBlock().isPrimary() && ((TileReactorCell)this.getMultiBlock().get()).func_70301_a(0) == null) {
            return itemStack.func_77973_b() instanceof IReactorComponent;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return ((TileReactorCell)this.getMultiBlock().get()).tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == Atomic.FLUID_PLASMA;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == Atomic.FLUID_TOXIC_WASTE;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.getMultiBlock().isPrimary() && this.getMultiBlock().isConstructed()) {
            return INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }

    public void heat(long energy) {
        this.internalEnergy = Math.max(this.internalEnergy + energy, 0L);
    }

    public float getTemperature() {
        return this.temperature;
    }
}

