/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.particle.accelerator;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IElectromagnet;
import resonant.api.IRotatable;
import resonant.lib.network.Synced;
import resonant.lib.prefab.tile.TileElectricalInventory;
import resonantinduction.atomic.Atomic;
import resonantinduction.atomic.particle.accelerator.EntityParticle;
import resonantinduction.atomic.particle.accelerator.ItemDarkMatter;
import resonantinduction.atomic.particle.fulmination.ItemAntimatter;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.energy.IEnergyInterface;
import universalelectricity.api.vector.Vector3;

public class TileAccelerator
extends TileElectricalInventory
implements IElectromagnet,
IRotatable,
IInventory,
ISidedInventory,
IVoltageInput {
    public static final int energyPerTick = 4800000;
    public static final float clientParticleVelocity = 0.9f;
    @Synced
    public float totalEnergyConsumed = 0.0f;
    @Synced
    public int antimatter;
    public EntityParticle entityParticle;
    @Synced
    public float velocity;
    @Synced
    private long clientEnergy = 0L;
    private int lastSpawnTick = 0;
    private int antiMatterDensityMultiplyer = 1;
    private static final int DENSITY_MULTIPLYER_DEFAULT = 1;

    public TileAccelerator() {
        this.energy = new EnergyStorageHandler(9600000L, 240000L);
        this.maxSlots = 4;
        this.antiMatterDensityMultiplyer = 1;
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return obj instanceof IEnergyInterface;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (doReceive) {
            this.totalEnergyConsumed += (float)receive;
        }
        if (this.func_70301_a(0) != null && (this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n) > 0)) {
            return super.onReceiveEnergy(from, receive, doReceive);
        }
        return 0L;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.clientEnergy = this.energy.getEnergy();
            this.velocity = 0.0f;
            if (this.entityParticle != null) {
                this.velocity = (float)this.entityParticle.getParticleVelocity();
            }
            if (Atomic.isItemStackEmptyCell(this.func_70301_a(1)) && this.func_70301_a((int)1).field_77994_a > 0 && this.antimatter >= 125) {
                if (this.func_70301_a(2) != null) {
                    ItemStack newStack;
                    if (this.func_70301_a((int)2).field_77993_c == Atomic.itemAntimatter.field_77779_bT && newStack.field_77994_a < (newStack = this.func_70301_a(2).func_77946_l()).func_77976_d()) {
                        this.func_70298_a(1, 1);
                        this.antimatter -= 125;
                        ++newStack.field_77994_a;
                        this.func_70299_a(2, newStack);
                    }
                } else {
                    this.antimatter -= 125;
                    this.func_70298_a(1, 1);
                    this.func_70299_a(2, new ItemStack(Atomic.itemAntimatter));
                }
            }
            if (this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                if (this.energy.checkExtract()) {
                    if (this.entityParticle == null) {
                        if (this.func_70301_a(0) != null && this.lastSpawnTick >= 40) {
                            Vector3 spawnAcceleratedParticle = new Vector3((TileEntity)this);
                            spawnAcceleratedParticle.translate(this.getDirection().getOpposite());
                            spawnAcceleratedParticle.translate(0.5);
                            if (EntityParticle.canRenderAcceleratedParticle(this.field_70331_k, spawnAcceleratedParticle)) {
                                this.totalEnergyConsumed = 0.0f;
                                this.entityParticle = new EntityParticle(this.field_70331_k, spawnAcceleratedParticle, new Vector3((TileEntity)this), this.getDirection().getOpposite());
                                this.field_70331_k.func_72838_d((Entity)this.entityParticle);
                                this.CalculateParticleDensity();
                                this.func_70298_a(0, 1);
                                this.lastSpawnTick = 0;
                            }
                        }
                    } else {
                        if (this.entityParticle.field_70128_L) {
                            if (this.entityParticle.didParticleCollide && (double)this.field_70331_k.field_73012_v.nextFloat() <= Settings.darkMatterSpawnChance) {
                                this.incrStackSize(3, new ItemStack(Atomic.itemDarkMatter));
                            }
                            this.entityParticle = null;
                        } else if (this.velocity > 0.9f) {
                            this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "resonantinduction:antimatter", 2.0f, 1.0f - this.field_70331_k.field_73012_v.nextFloat() * 0.3f);
                            int generatedAntimatter = 5 + this.field_70331_k.field_73012_v.nextInt(this.antiMatterDensityMultiplyer);
                            this.antimatter += generatedAntimatter;
                            this.totalEnergyConsumed = 0.0f;
                            this.entityParticle.func_70106_y();
                            this.entityParticle = null;
                        }
                        if (this.entityParticle != null) {
                            this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "resonantinduction:accelerator", 1.5f, (float)((double)0.6f + 0.4 * this.entityParticle.getParticleVelocity() / (double)0.9f));
                        }
                    }
                    this.energy.extractEnergy();
                } else {
                    if (this.entityParticle != null) {
                        this.entityParticle.func_70106_y();
                    }
                    this.entityParticle = null;
                }
            } else {
                if (this.entityParticle != null) {
                    this.entityParticle.func_70106_y();
                }
                this.entityParticle = null;
            }
            if (this.ticks % 5L == 0L) {
                for (EntityPlayer player : this.getPlayersUsing()) {
                    PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
                }
            }
            ++this.lastSpawnTick;
        }
    }

    private void CalculateParticleDensity() {
        ItemStack itemToAccelerate = this.func_70301_a(0);
        if (itemToAccelerate != null) {
            this.antiMatterDensityMultiplyer = 1;
            try {
                Block potentialBlock = Block.field_71973_m[itemToAccelerate.func_77973_b().field_77779_bT];
                if (potentialBlock != null) {
                    this.antiMatterDensityMultiplyer = (int)Math.abs(potentialBlock.field_71989_cb);
                    if (this.antiMatterDensityMultiplyer <= 0) {
                        this.antiMatterDensityMultiplyer = 1;
                    }
                }
            }
            catch (Exception err) {
                this.antiMatterDensityMultiplyer = 1;
            }
        }
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.totalEnergyConsumed = par1NBTTagCompound.func_74760_g("totalEnergyConsumed");
        this.antimatter = par1NBTTagCompound.func_74762_e("antimatter");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74776_a("totalEnergyConsumed", this.totalEnergyConsumed);
        par1NBTTagCompound.func_74768_a("antimatter", this.antimatter);
    }

    public long getVoltageInput(ForgeDirection dir) {
        return 1000L;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slotID, ItemStack itemStack, int j) {
        return this.func_94041_b(slotID, itemStack) && slotID != 2 && slotID != 3;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 2 || slotID == 3;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        switch (i) {
            case 0: {
                return true;
            }
            case 1: {
                return Atomic.isItemStackEmptyCell(itemStack);
            }
            case 2: {
                return itemStack.func_77973_b() instanceof ItemAntimatter;
            }
            case 3: {
                return itemStack.func_77973_b() instanceof ItemDarkMatter;
            }
        }
        return false;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public void onWrongVoltage(ForgeDirection direction, long voltage) {
    }

    public boolean isRunning() {
        return true;
    }
}

