/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.process;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.prefab.tile.TileElectricalInventory;

public abstract class TileProcess
extends TileElectricalInventory {
    protected int inputSlot;
    protected int outputSlot;
    protected int tankInputFillSlot;
    protected int tankInputDrainSlot;
    protected int tankOutputFillSlot;
    protected int tankOutputDrainSlot;
    protected String machineName;

    public void func_70316_g() {
        super.func_70316_g();
        if (this.getInputTank() != null) {
            this.fillOrDrainTank(this.tankInputFillSlot, this.tankInputDrainSlot, this.getInputTank());
        }
        if (this.getOutputTank() != null) {
            this.fillOrDrainTank(this.tankOutputFillSlot, this.tankOutputDrainSlot, this.getOutputTank());
        }
    }

    public void fillOrDrainTank(int containerInput, int containerOutput, FluidTank tank) {
        FluidStack avaliable;
        ItemStack inputStack = this.func_70301_a(containerInput);
        ItemStack outputStack = this.func_70301_a(containerOutput);
        if (FluidContainerRegistry.isFilledContainer((ItemStack)inputStack)) {
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputStack);
            ItemStack result = inputStack.func_77973_b().getContainerItemStack(inputStack);
            if (result != null && tank.fill(fluidStack, false) >= fluidStack.amount && (outputStack == null || result.func_77969_a(outputStack))) {
                tank.fill(fluidStack, true);
                this.func_70298_a(containerInput, 1);
                this.incrStackSize(containerOutput, result);
            }
        } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)inputStack) && (avaliable = tank.getFluid()) != null) {
            ItemStack result = FluidContainerRegistry.fillFluidContainer((FluidStack)avaliable, (ItemStack)inputStack);
            FluidStack filled = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
            if (result != null && filled != null && (outputStack == null || result.func_77969_a(outputStack))) {
                this.func_70298_a(containerInput, 1);
                this.incrStackSize(containerOutput, result);
                tank.drain(filled.amount, true);
            }
        }
    }

    public RecipeResource[] getResults() {
        ItemStack inputStack = this.func_70301_a(this.inputSlot);
        RecipeResource[] mixedResult = MachineRecipes.INSTANCE.getOutput(this.machineName, new Object[]{inputStack, this.getInputTank().getFluid()});
        if (mixedResult.length > 0) {
            return mixedResult;
        }
        return MachineRecipes.INSTANCE.getOutput(this.machineName, new Object[]{inputStack});
    }

    public boolean hasResult() {
        return this.getResults().length > 0;
    }

    public abstract FluidTank getInputTank();

    public abstract FluidTank getOutputTank();
}

