/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.process.fission;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IRotatable;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.prefab.tile.TileElectricalInventory;
import resonantinduction.atomic.Atomic;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

public class TileCentrifuge
extends TileElectricalInventory
implements ISidedInventory,
IPacketReceiver,
IFluidHandler,
IRotatable,
IVoltageInput {
    public static final int SHI_JIAN = 1200;
    public static final long DIAN = 500000L;
    public final FluidTank gasTank = new FluidTank(Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.copy(), 5000);
    public int timer = 0;
    public float rotation = 0.0f;

    public TileCentrifuge() {
        this.energy = new EnergyStorageHandler(1000000L);
        this.maxSlots = 4;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.timer > 0) {
            this.rotation += 0.45f;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.ticks % 20L == 0L) {
                for (int i = 0; i < 6; ++i) {
                    IFluidHandler fluidHandler;
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    TileEntity tileEntity = VectorHelper.getTileEntityFromSide((World)this.field_70331_k, (Vector3)new Vector3((TileEntity)this), (ForgeDirection)direction);
                    if (!(tileEntity instanceof IFluidHandler) || tileEntity.getClass() == ((Object)((Object)this)).getClass() || (fluidHandler = (IFluidHandler)tileEntity) == null) continue;
                    FluidStack requestFluid = Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.copy();
                    requestFluid.amount = this.gasTank.getCapacity() - Atomic.getFluidAmount(this.gasTank.getFluid());
                    FluidStack receiveFluid = fluidHandler.drain(direction.getOpposite(), requestFluid, true);
                    if (receiveFluid == null || receiveFluid.amount <= 0 || this.gasTank.fill(receiveFluid, false) <= 0) continue;
                    this.gasTank.fill(receiveFluid, true);
                }
            }
            if (this.nengYong()) {
                this.discharge(this.func_70301_a(0));
                if (this.energy.extractEnergy(500000L, false) >= 500000L) {
                    if (this.timer == 0) {
                        this.timer = 1200;
                    }
                    if (this.timer > 0) {
                        --this.timer;
                        if (this.timer < 1) {
                            this.yong();
                            this.timer = 0;
                        }
                    } else {
                        this.timer = 0;
                    }
                    this.energy.extractEnergy(500000L, true);
                }
            } else {
                this.timer = 0;
            }
            if (this.ticks % 10L == 0L) {
                for (EntityPlayer player : this.getPlayersUsing()) {
                    PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
                }
            }
        }
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (this.nengYong()) {
            return super.onReceiveEnergy(from, receive, doReceive);
        }
        return 0L;
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.timer = data.readInt();
            this.gasTank.setFluid(new FluidStack(Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.fluidID, data.readInt()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{this.timer, Atomic.getFluidAmount(this.gasTank.getFluid())});
    }

    public void func_70295_k_() {
        if (!this.field_70331_k.field_72995_K) {
            for (EntityPlayer player : this.getPlayersUsing()) {
                PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
            }
        }
    }

    public void func_70305_f() {
    }

    public boolean nengYong() {
        if (this.gasTank.getFluid() != null && this.gasTank.getFluid().amount >= Settings.uraniumHexaflourideRatio) {
            return this.func_94041_b(2, new ItemStack(Atomic.itemUranium)) && this.func_94041_b(3, new ItemStack(Atomic.itemUranium, 1, 1));
        }
        return false;
    }

    public void yong() {
        if (this.nengYong()) {
            this.gasTank.drain(Settings.uraniumHexaflourideRatio, true);
            if ((double)this.field_70331_k.field_73012_v.nextFloat() > 0.6) {
                this.incrStackSize(2, new ItemStack(Atomic.itemUranium));
            } else {
                this.incrStackSize(3, new ItemStack(Atomic.itemUranium, 1, 1));
            }
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.timer = nbt.func_74762_e("smeltingTicks");
        NBTTagCompound compound = nbt.func_74775_l("gas");
        this.gasTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.timer);
        if (this.gasTank.getFluid() != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.gasTank.getFluid().writeToNBT(compound);
            nbt.func_74782_a("gas", (NBTBase)compound);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.isFluidEqual(resource)) {
            return this.gasTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Atomic.FLUIDSTACK_URANIUM_HEXAFLOURIDE.fluidID == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.gasTank.getInfo()};
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArray = nArray3;
            nArray3[1] = 3;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemStack, int side) {
        return slotID == 1 && this.func_94041_b(slotID, itemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 2 || slotID == 3;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        switch (i) {
            case 0: {
                return CompatibilityModule.isHandler((Object)itemStack.func_77973_b());
            }
            case 1: {
                return true;
            }
            case 2: {
                return itemStack.field_77993_c == Atomic.itemUranium.field_77779_bT;
            }
            case 3: {
                return itemStack.field_77993_c == Atomic.itemUranium.field_77779_bT;
            }
        }
        return false;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public long getVoltageInput(ForgeDirection from) {
        return 1000L;
    }

    public void onWrongVoltage(ForgeDirection direction, long voltage) {
    }
}

