/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.process.sensor;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import li.cil.oc.api.network.Arguments;
import li.cil.oc.api.network.Callback;
import li.cil.oc.api.network.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.content.module.TileBase;
import resonant.lib.network.PacketHandler;
import resonant.lib.network.Synced;
import resonant.lib.prefab.item.ItemBlockSaved;
import resonant.lib.thermal.ThermalGrid;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.atomic.process.sensor.ItemBlockThermometer;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")
public class TileThermometer
extends TileBase
implements IPeripheral,
SimpleComponent {
    public static final int MAX_THRESHOLD = 5000;
    private static Icon iconSide;
    @Synced
    public float detectedTemperature = 295.0f;
    @Synced
    public float previousDetectedTemperature = 295.0f;
    @Synced
    public Vector3 trackCoordinate;
    @Synced
    private int threshold = 1000;
    @Synced
    private boolean isProvidingPower = false;

    public TileThermometer() {
        super(Material.field_76233_E);
        this.canProvidePower = true;
        this.normalRender = false;
        this.forceStandardRender = true;
        this.itemBlock = ItemBlockThermometer.class;
    }

    public Icon getIcon(int side, int meta) {
        return side == 1 || side == 0 ? super.getIcon(side, meta) : iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        super.registerIcons(iconRegister);
        iconSide = iconRegister.func_94245_a("resonantinduction:machine");
    }

    protected boolean use(EntityPlayer player, int side, Vector3 hit) {
        if (player.func_70093_af()) {
            this.setThreshold(this.getThershold() + 100);
        } else {
            this.setThreshold(this.getThershold() - 100);
        }
        return true;
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 hit) {
        if (player.func_70093_af()) {
            this.setThreshold(this.getThershold() - 10);
        } else {
            this.setThreshold(this.getThershold() + 10);
        }
        return true;
    }

    public int getStrongRedstonePower(IBlockAccess access, int side) {
        return this.isProvidingPower ? 15 : 0;
    }

    public ArrayList<ItemStack> getDrops(int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void onRemove(int par5, int par6) {
        ItemStack stack = ItemBlockSaved.getItemStackWithNBT((Block)this.func_70311_o(), (World)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
        InventoryUtility.dropItemStack((World)this.world(), (Vector3)this.center(), (ItemStack)stack);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.ticks % 10L == 0L) {
            this.detectedTemperature = this.trackCoordinate != null ? ThermalGrid.getTemperature((VectorWorld)new VectorWorld(this.world(), (IVector3)this.trackCoordinate)) : ThermalGrid.getTemperature((VectorWorld)new VectorWorld((TileEntity)this));
            if (this.detectedTemperature != this.previousDetectedTemperature || this.isProvidingPower != this.isOverThreshold()) {
                this.previousDetectedTemperature = this.detectedTemperature;
                this.isProvidingPower = this.isOverThreshold();
                this.notifyChange();
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)25.0);
            }
        }
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public void setTrack(Vector3 track) {
        this.trackCoordinate = track;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.threshold = nbt.func_74762_e("threshold");
        this.trackCoordinate = nbt.func_74764_b("trackCoordinate") ? new Vector3(nbt.func_74775_l("trackCoordinate")) : null;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("threshold", this.threshold);
        if (this.trackCoordinate != null) {
            nbt.func_74766_a("trackCoordinate", this.trackCoordinate.writeToNBT(new NBTTagCompound()));
        }
    }

    public int getThershold() {
        return this.threshold;
    }

    public void setThreshold(int newThreshold) {
        this.threshold = newThreshold % 5000;
        if (this.threshold <= 0) {
            this.threshold = 5000;
        }
        this.markUpdate();
    }

    public boolean isOverThreshold() {
        return this.detectedTemperature >= (float)this.getThershold();
    }

    public String getType() {
        return "AS Thermometer";
    }

    public String[] getMethodNames() {
        return new String[]{"getTemperature", "getWarningTemperature", "setWarningTemperature", "isAboveWarningTemperature"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        boolean getTemperature = false;
        boolean getWarningTemperature = true;
        int setWarningTemperature = 2;
        int isAboveWarningTemperature = 3;
        switch (method) {
            case 0: {
                return new Object[]{Float.valueOf(this.detectedTemperature)};
            }
            case 1: {
                return new Object[]{this.getThershold()};
            }
            case 3: {
                return new Object[]{this.isOverThreshold()};
            }
            case 2: {
                if (arguments.length <= 0) {
                    throw new IllegalArgumentException("Not enough Arguments. Must provide one argument");
                }
                if (arguments.length >= 2) {
                    throw new IllegalArgumentException("Too many Arguments. Must provide one argument");
                }
                if (!(arguments[0] instanceof Number)) {
                    throw new IllegalArgumentException("Invalid Argument. Must provide a number");
                }
                TileThermometer tileThermometer = this;
                synchronized (tileThermometer) {
                    this.setThreshold((Integer)arguments[0]);
                }
                return new Object[]{this.threshold == (Integer)arguments[0]};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return this.equals(this);
    }

    public String getComponentName() {
        return "AS_Thermometer";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getTemperature(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.detectedTemperature)};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getWarningTemperature(Context context, Arguments args) {
        return new Object[]{this.getThershold()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isAboveWarningTemperature(Context context, Arguments args) {
        return new Object[]{this.isOverThreshold()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setWarningTemperature(Context context, Arguments args) {
        if (args.count() <= 0) {
            throw new IllegalArgumentException("Not enough Arguments. Must provide one argument");
        }
        if (args.count() >= 2) {
            throw new IllegalArgumentException("Too many Arguments. Must provide one argument");
        }
        if (!args.isInteger(0)) {
            throw new IllegalArgumentException("Invalid Argument. Must provide an Integer");
        }
        TileThermometer tileThermometer = this;
        synchronized (tileThermometer) {
            this.setThreshold(args.checkInteger(0));
        }
        return new Object[]{this.threshold == args.checkInteger(0)};
    }
}

