/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.atomic.process.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import resonant.lib.prefab.turbine.TileTurbine;

@SideOnly(value=Side.CLIENT)
public class RenderElectricTurbine
extends TileEntitySpecialRenderer {
    public static final IModelCustom MODEL_SMALL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/turbineSmall.tcn");
    public static final IModelCustom MODEL_LARGE = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/turbineLarge.tcn");
    public static final ResourceLocation SMALL_TEXTURE = new ResourceLocation("resonantinduction", "models/turbineSmall.png");
    public static final ResourceLocation LARGE_TEXTURE = new ResourceLocation("resonantinduction", "models/turbineLarge.png");

    public void func_76894_a(TileEntity t, double x, double y, double z, float f) {
        TileTurbine tile = (TileTurbine)t;
        if (tile.getMultiBlock().isPrimary()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            if (tile.getMultiBlock().isConstructed()) {
                this.func_110628_a(LARGE_TEXTURE);
                Object[] blades = new String[]{"Blade1", "Blade2", "Blade3", "Blade4", "Blade5", "Blade6"};
                Object[] mediumBlades = new String[]{"MediumBlade1", "MediumBlade2", "MediumBlade3", "MediumBlade4", "MediumBlade5", "MediumBlade6"};
                Object[] largeBlades = new String[]{"LargeBlade1", "LargeBlade2", "LargeBlade3", "LargeBlade4", "LargeBlade5", "LargeBlade6"};
                GL11.glPushMatrix();
                GL11.glRotated((double)Math.toDegrees(tile.rotation), (double)0.0, (double)1.0, (double)0.0);
                MODEL_LARGE.renderOnly((String[])blades);
                MODEL_LARGE.renderOnly((String[])largeBlades);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotated((double)(-Math.toDegrees(tile.rotation)), (double)0.0, (double)1.0, (double)0.0);
                MODEL_LARGE.renderOnly((String[])mediumBlades);
                GL11.glPopMatrix();
                MODEL_LARGE.renderAllExcept((String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])blades, (Object[])mediumBlades), (Object[])largeBlades));
            } else {
                GL11.glScalef((float)1.0f, (float)1.1f, (float)1.0f);
                this.func_110628_a(SMALL_TEXTURE);
                Object[] bladesA = new String[3];
                for (int i = 0; i < bladesA.length; ++i) {
                    bladesA[i] = "BLADE A" + (i + 1) + " SPINS";
                }
                Object[] sheildsA = new String[6];
                for (int i = 0; i < sheildsA.length; ++i) {
                    sheildsA[i] = "SHIELD A" + (i + 1) + " SPINS";
                }
                Object[] bladesB = new String[3];
                for (int i = 0; i < bladesB.length; ++i) {
                    bladesB[i] = "BLADE B" + (i + 1) + " SPINS";
                }
                Object[] sheildsB = new String[6];
                for (int i = 0; i < sheildsB.length; ++i) {
                    sheildsB[i] = "SHIELD B" + (i + 1) + " SPINS";
                }
                Object[] renderA = (String[])ArrayUtils.addAll((Object[])bladesA, (Object[])sheildsA);
                Object[] renderB = (String[])ArrayUtils.addAll((Object[])bladesB, (Object[])sheildsB);
                GL11.glPushMatrix();
                GL11.glRotated((double)Math.toDegrees(tile.rotation), (double)0.0, (double)1.0, (double)0.0);
                MODEL_SMALL.renderOnly((String[])renderA);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotated((double)(-Math.toDegrees(tile.rotation)), (double)0.0, (double)1.0, (double)0.0);
                MODEL_SMALL.renderOnly((String[])renderB);
                GL11.glPopMatrix();
                MODEL_SMALL.renderAllExcept((String[])ArrayUtils.addAll((Object[])renderA, (Object[])renderB));
            }
            GL11.glPopMatrix();
        }
    }
}

