/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.block.BlockGenerator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class ItemBlockGenerator
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem {
    public Block metaBlock;

    public ItemBlockGenerator(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public Icon func_77617_a(int i) {
        return this.metaBlock.func_71858_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockGenerator.GeneratorType.getFromMetadata(itemstack.func_77960_j()) == null) {
            return "KillMe!";
        }
        return this.func_77658_a() + "." + BlockGenerator.GeneratorType.getFromMetadata((int)itemstack.func_77960_j()).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + EnumColor.AQUA + "shift" + EnumColor.GREY + " for details.");
        } else {
            list.add(EnumColor.BRIGHT_GREEN + "Stored Energy: " + EnumColor.GREY + MekanismUtils.getEnergyDisplay((double)this.getEnergy(itemstack)));
            if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                list.add(EnumColor.PINK + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + EnumColor.GREY + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            list.add(EnumColor.AQUA + "Inventory: " + EnumColor.GREY + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        int blockID = world.func_72798_a(x, y, z);
        if (stack.func_77960_j() == BlockGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
            if (blockID != 0 && !Block.field_71973_m[blockID].isBlockReplaceable(world, x, y, z)) {
                return false;
            }
            for (int xPos = -1; xPos <= 1; ++xPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (world.func_72798_a(x + xPos, y + 2, z + zPos) == 0 && y + 2 <= 255) continue;
                    place = false;
                }
            }
        } else if (stack.func_77960_j() == BlockGenerator.GeneratorType.WIND_TURBINE.meta) {
            if (blockID != 0 && !Block.field_71973_m[blockID].isBlockReplaceable(world, x, y, z)) {
                return false;
            }
            for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                if (world.func_72798_a(x, yPos, z) == 0 && yPos <= 255) continue;
                place = false;
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_72796_p(x, y, z);
            tileEntity.electricityStored = this.getEnergy(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)tileEntity).setFluidStack(this.getFluidStack(stack), new Object[]{stack});
            }
            return true;
        }
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.canSend(itemStack);
    }

    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    public int getTier(ItemStack itemStack) {
        return 4;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }

    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.fluidID == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77960_j() == 2;
    }

    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return BlockGenerator.GeneratorType.getFromMetadata((int)itemStack.func_77960_j()).maxEnergy;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    public boolean isMetadataSpecific() {
        return true;
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager((IEnergizedItem)this);
    }
}

