/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import buildcraft.api.power.IPowerReceptor;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityGenerator
extends TileEntityElectricBlock
implements IPowerReceptor,
IPeripheral,
IActiveState,
IHasSound,
IRedstoneControl {
    public double output;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public IRedstoneControl.RedstoneControl controlType;

    public TileEntityGenerator(String name, double maxEnergy, double out) {
        super(name, maxEnergy);
        this.powerHandler.configure(0.0f, 0.0f, 0.0f, 0.0f);
        this.output = out;
        this.isActive = false;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound((Object)this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.clientActive = this.isActive;
                    PacketHandler.sendPacket((PacketHandler.Transmission)PacketHandler.Transmission.ALL_CLIENTS, (IMekanismPacket)new PacketTileEntity().setParams(new Object[]{Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())}), (Object[])new Object[0]);
                }
            }
            if (MekanismUtils.canFunction((TileEntity)this)) {
                CableUtils.emit((TileEntityElectricBlock)this);
            }
        }
    }

    public double getMaxOutput() {
        return this.output;
    }

    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing));
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound((TileEntity)this);
        }
    }

    public abstract boolean canOperate();

    public boolean getActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket((PacketHandler.Transmission)PacketHandler.Transmission.ALL_CLIENTS, (IMekanismPacket)new PacketTileEntity().setParams(new Object[]{Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())}), (Object[])new Object[0]);
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.clientActive = active;
        }
    }

    public String getType() {
        return this.func_70303_b();
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n);
        }
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public String getSoundPath() {
        return this.fullName.replace("Advanced", "") + ".ogg";
    }

    public float getVolumeMultiplier() {
        return 1.0f;
    }

    public boolean renderUpdate() {
        return true;
    }

    public boolean lightUpdate() {
        return true;
    }

    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk((TileEntity)this);
    }

    protected void reconfigure() {
        this.powerHandler.configure(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

