/*
 * Decompiled with CFR 0.152.
 */
package com.github.AbrarSyed.secretroomsmod.common;

import com.github.AbrarSyed.secretroomsmod.common.fake.FakeWorld;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.world.World;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

public class ProxyCommon {
    private HashMap<Integer, FakeWorld> fakes = new HashMap();
    private HashSet<String> awaySet = new HashSet();

    public void loadRenderStuff() {
    }

    public void loadKeyStuff() {
    }

    public void onServerStop(FMLServerStoppingEvent e) {
        this.fakes.clear();
        this.awaySet.clear();
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof FakeWorld) {
            return;
        }
        int dim = event.world.field_73011_w.field_76574_g;
        this.fakes.put(dim, FakeWorld.getFakeWorldFor(event.world));
    }

    @ForgeSubscribe(priority=EventPriority.LOWEST)
    public void onWorldUnLoad(WorldEvent.Unload event) {
        if (event.world instanceof FakeWorld) {
            return;
        }
        int dim = event.world.field_73011_w.field_76574_g;
        this.fakes.remove(dim);
    }

    public FakeWorld getFakeWorld(World world) {
        int dim = world.field_73011_w.field_76574_g;
        return this.fakes.get(dim);
    }

    public void onKeyPress(String username) {
        if (this.awaySet.contains(username)) {
            this.awaySet.remove(username);
        } else {
            this.awaySet.add(username);
        }
    }

    public boolean getFaceTowards(String username) {
        return !this.awaySet.contains(username);
    }
}

