/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import mrtjp.projectred.core.fx.CoreParticle;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.fx.ParticleManagement;

public class ParticleLogicTrail
extends ParticleLogic {
    private int ticksBetweenSpawns = 2;
    private int updateTicks;
    private final String particleName;
    private IParticleBuilder builder;

    public ParticleLogicTrail(String particleName, IParticleBuilder builder) {
        this.particleName = particleName;
        this.builder = builder;
        this.updateTicks = 0;
    }

    public ParticleLogicTrail setTicksBetweenSpawns(int ticks) {
        this.ticksBetweenSpawns = ticks;
        return this;
    }

    @Override
    public void doUpdate() {
        ++this.updateTicks;
        if (this.updateTicks == this.ticksBetweenSpawns) {
            this.updateTicks = 0;
            CoreParticle c = ParticleManagement.instance.spawn(this.particle.q, this.particleName, this.particle.u, this.particle.v, this.particle.w);
            if (c != null) {
                this.builder.build(c);
            }
        }
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicTrail clone = new ParticleLogicTrail(this.particleName, this.builder).setTicksBetweenSpawns(this.ticksBetweenSpawns);
        return clone;
    }

    public static interface IParticleBuilder {
        public void build(CoreParticle var1);
    }
}

