/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.grid.fluid;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonantinduction.core.grid.fluid.IFluidDistribution;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.IUpdate;
import universalelectricity.core.net.NetworkTickHandler;
import universalelectricity.core.net.NodeNetwork;

public abstract class FluidDistributionetwork
extends NodeNetwork<FluidDistributionetwork, IFluidDistribution, IFluidHandler>
implements IUpdate {
    protected FluidTank tank = new FluidTank(0);
    public boolean needsUpdate = false;

    public FluidDistributionetwork() {
        super(IFluidDistribution.class);
    }

    public void addConnector(IFluidDistribution connector) {
        super.addConnector((IConnector)connector);
        NetworkTickHandler.addNetwork((IUpdate)this);
    }

    public boolean canUpdate() {
        return this.needsUpdate && this.getConnectors().size() > 0;
    }

    public boolean continueUpdate() {
        return this.canUpdate();
    }

    public void reconstruct() {
        this.tank.setCapacity(0);
        this.tank.setFluid(null);
        super.reconstruct();
        this.needsUpdate = true;
        NetworkTickHandler.addNetwork((IUpdate)this);
    }

    public void reconstructConnector(IFluidDistribution connector) {
        FluidTank connectorTank;
        if (connector.getNetwork() instanceof FluidDistributionetwork) {
            connector.setNetwork((Object)this);
        }
        if ((connectorTank = connector.getInternalTank()) != null) {
            this.tank.setCapacity(this.tank.getCapacity() + connectorTank.getCapacity());
            if (connectorTank.getFluid() != null) {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(connectorTank.getFluid().copy());
                } else if (this.tank.getFluid().isFluidEqual(connectorTank.getFluid())) {
                    this.tank.getFluid().amount += connectorTank.getFluidAmount();
                } else if (this.tank.getFluid() != null) {
                    // empty if block
                }
            }
        }
    }

    public int fill(IFluidDistribution source, ForgeDirection from, FluidStack resource, boolean doFill) {
        int fill = this.getTank().fill(resource.copy(), doFill);
        if (fill > 0) {
            this.needsUpdate = true;
            NetworkTickHandler.addNetwork((IUpdate)this);
        }
        return fill;
    }

    public FluidStack drain(IFluidDistribution source, ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.isFluidEqual(this.getTank().getFluid())) {
            FluidStack drain = this.getTank().drain(resource.amount, doDrain);
            this.needsUpdate = true;
            NetworkTickHandler.addNetwork((IUpdate)this);
            return drain;
        }
        return null;
    }

    public FluidStack drain(IFluidDistribution source, ForgeDirection from, int resource, boolean doDrain) {
        FluidStack drain = this.getTank().drain(resource, doDrain);
        this.needsUpdate = true;
        NetworkTickHandler.addNetwork((IUpdate)this);
        return drain;
    }

    public FluidTank getTank() {
        if (this.tank == null) {
            this.tank = new FluidTank(0);
        }
        return this.tank;
    }

    public Class getConnectorClass() {
        return IFluidDistribution.class;
    }

    public FluidTankInfo[] getTankInfo() {
        return new FluidTankInfo[]{this.getTank().getInfo()};
    }

    public String toString() {
        return super.toString() + " Volume: " + this.tank.getFluidAmount();
    }
}

