/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.grid.fluid;

import codechicken.multipart.TMultiPart;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.Node;
import resonant.lib.grid.TickingGrid;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import universalelectricity.api.vector.Vector3;

public class FluidPressureNode
extends Node<IPressureNodeProvider, TickingGrid, Object> {
    public int maxFlowRate = 20;
    public int maxPressure = 100;
    protected byte connectionMap = Byte.parseByte("111111", 2);
    private int pressure = 0;

    public FluidPressureNode(IPressureNodeProvider parent) {
        super((INodeProvider)parent);
    }

    public FluidPressureNode setConnection(byte connectionMap) {
        this.connectionMap = connectionMap;
        return this;
    }

    public void update(float deltaTime) {
        if (!this.world().field_72995_K) {
            this.updatePressure();
            this.distribute();
        }
    }

    protected void updatePressure() {
        int totalPressure = 0;
        int findCount = 0;
        int minPressure = 0;
        int maxPressure = 0;
        for (Map.Entry entry : new HashMap(this.getConnections()).entrySet()) {
            Object obj = entry.getKey();
            if (!(obj instanceof FluidPressureNode)) continue;
            int pressure = ((FluidPressureNode)((Object)obj)).getPressure(((ForgeDirection)entry.getValue()).getOpposite());
            minPressure = Math.min(pressure, minPressure);
            maxPressure = Math.max(pressure, maxPressure);
            totalPressure += pressure;
            ++findCount;
        }
        if (findCount == 0) {
            this.setPressure(0);
        } else {
            if (minPressure < 0) {
                ++minPressure;
            }
            if (maxPressure > 0) {
                --maxPressure;
            }
            this.setPressure(Math.max(minPressure, Math.min(maxPressure, totalPressure / findCount + Integer.signum(totalPressure))));
        }
    }

    public void distribute() {
        for (Map.Entry entry : new HashMap(this.getConnections()).entrySet()) {
            FluidStack drainStack;
            Object obj = entry.getKey();
            ForgeDirection dir = (ForgeDirection)entry.getValue();
            if (obj instanceof FluidPressureNode) {
                FluidStack drainStack2;
                FluidTank tankB;
                int amountA;
                FluidStack fluidA;
                FluidTank tankA;
                int pressureB;
                FluidPressureNode otherNode = (FluidPressureNode)((Object)obj);
                int pressureA = this.getPressure(dir);
                if (pressureA < (pressureB = otherNode.getPressure(dir.getOpposite())) || (tankA = ((IPressureNodeProvider)this.parent).getPressureTank()) == null || (fluidA = tankA.getFluid()) == null || (amountA = fluidA.amount) <= 0 || (tankB = ((IPressureNodeProvider)otherNode.parent).getPressureTank()) == null) continue;
                int amountB = tankB.getFluidAmount();
                int quantity = Math.max(pressureA > pressureB ? (pressureA - pressureB) * this.getMaxFlowRate() : 0, Math.min((amountA - amountB) / 2, this.getMaxFlowRate()));
                if ((quantity = Math.min(Math.min(quantity, tankB.getCapacity() - amountB), amountA)) <= 0 || (drainStack2 = ((IPressureNodeProvider)this.parent).drain(dir.getOpposite(), quantity, false)) == null || drainStack2.amount <= 0) continue;
                ((IPressureNodeProvider)this.parent).drain(dir.getOpposite(), ((IPressureNodeProvider)otherNode.parent).fill(dir, drainStack2, true), true);
                continue;
            }
            if (!(obj instanceof IFluidHandler)) continue;
            IFluidHandler fluidHandler = (IFluidHandler)obj;
            int pressure = this.getPressure(dir);
            int tankPressure = fluidHandler instanceof IPressureNodeProvider ? ((FluidPressureNode)((IPressureNodeProvider)fluidHandler).getNode(FluidPressureNode.class, dir.getOpposite())).getPressure(dir.getOpposite()) : 0;
            FluidTank sourceTank = ((IPressureNodeProvider)this.parent).getPressureTank();
            int transferAmount = (Math.max(pressure, tankPressure) - Math.min(pressure, tankPressure)) * this.getMaxFlowRate();
            if (pressure > tankPressure) {
                if (sourceTank.getFluidAmount() <= 0 || transferAmount <= 0) continue;
                FluidStack drainStack3 = ((IPressureNodeProvider)this.parent).drain(dir.getOpposite(), transferAmount, false);
                ((IPressureNodeProvider)this.parent).drain(dir.getOpposite(), fluidHandler.fill(dir.getOpposite(), drainStack3, true), true);
                continue;
            }
            if (pressure >= tankPressure || transferAmount <= 0 || (drainStack = fluidHandler.drain(dir.getOpposite(), transferAmount, false)) == null) continue;
            fluidHandler.drain(dir.getOpposite(), ((IPressureNodeProvider)this.parent).fill(dir.getOpposite(), drainStack, true), true);
        }
    }

    public int getMaxFlowRate() {
        return this.maxFlowRate;
    }

    public void setPressure(int newPressure) {
        this.pressure = newPressure > 0 ? Math.min(this.maxPressure, newPressure) : Math.max(-this.maxPressure, newPressure);
    }

    public int getPressure(ForgeDirection dir) {
        return this.pressure;
    }

    public void doRecache() {
        this.connections.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            FluidPressureNode check;
            TileEntity tile = this.position().translate(dir).getTileEntity((IBlockAccess)this.world());
            if (!(tile instanceof IPressureNodeProvider) || (check = (FluidPressureNode)((IPressureNodeProvider)tile).getNode(FluidPressureNode.class, dir.getOpposite())) == null || !this.canConnect(dir, (Object)check) || !check.canConnect(dir.getOpposite(), (Object)this)) continue;
            this.connections.put(check, dir);
        }
    }

    public World world() {
        return this.parent instanceof TMultiPart ? ((TMultiPart)this.parent).world() : (this.parent instanceof TileEntity ? ((TileEntity)this.parent).func_70314_l() : null);
    }

    public Vector3 position() {
        return this.parent instanceof TMultiPart ? new Vector3((double)((TMultiPart)this.parent).x(), (double)((TMultiPart)this.parent).y(), (double)((TMultiPart)this.parent).z()) : (this.parent instanceof TileEntity ? new Vector3((TileEntity)this.parent) : null);
    }

    public boolean canConnect(ForgeDirection from, Object source) {
        return source instanceof FluidPressureNode && (this.connectionMap & 1 << from.ordinal()) != 0;
    }

    public TickingGrid newGrid() {
        return new TickingGrid((Node)this, FluidPressureNode.class);
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.pressure = nbt.func_74762_e("pressure");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("pressure", this.pressure);
    }
}

